/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.NotificationFilterPreferenceStore;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.stability.Unstable;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Named(value="R160100000XWIKI21738")
@Singleton
@Unstable
public class R160100000XWIKI21738DataMigration
extends AbstractHibernateDataMigration {
    private static final int BATCH_SIZE = 100;
    private static final String SEARCH_FILTERS_STATEMENT = "select nfp from DefaultNotificationFilterPreference nfp where nfp.owner not like :ownerLike and nfp.owner <> :mainWiki order by nfp.owner, nfp.internalId";
    private static final String DELETE_FILTER_STATEMENT = "delete from DefaultNotificationFilterPreference nfp where nfp.internalId IN (:listIds)";
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private QueryManager queryManager;
    @Inject
    private NotificationFilterPreferenceStore filterPreferenceStore;
    @Inject
    @Named(value="relative")
    private EntityReferenceResolver<String> entityReferenceResolver;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "Migrate filters in the same DB than their owners.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(160100000);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        return super.shouldExecute(startupVersion) && this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        List previousFilters;
        String mainWikiId = this.wikiDescriptorManager.getMainWikiId();
        List filters = null;
        do {
            try {
                previousFilters = filters;
                filters = this.queryManager.createQuery(SEARCH_FILTERS_STATEMENT, "hql").bindValue("ownerLike").literal(mainWikiId).literal(":").anyChars().query().bindValue("mainWiki", this.entityReferenceSerializer.serialize((EntityReference)new WikiReference(mainWikiId), new Object[0])).setLimit(100).execute();
                if (filters.isEmpty() || previousFilters != null && previousFilters.equals(filters)) continue;
                this.logger.info("Found [{}] filters to migrate...", (Object)filters.size());
                this.migrateFilters(filters);
            }
            catch (QueryException e) {
                throw new DataMigrationException("Error when trying to retrieve filters to move", (Throwable)e);
            }
        } while (!filters.isEmpty() && (previousFilters == null || !previousFilters.equals(filters)));
        if (previousFilters != null && previousFilters.equals(filters)) {
            throw new DataMigrationException("Error while performing the migration: filters are not properly deleted.");
        }
        this.logger.info("No more filters found to migrate.");
    }

    private void migrateFilters(List<DefaultNotificationFilterPreference> filters) throws XWikiException, DataMigrationException {
        EntityReference entityReference;
        ArrayList<Long> internalIds = new ArrayList<Long>();
        HashMap filtersToStore = new HashMap();
        for (DefaultNotificationFilterPreference defaultNotificationFilterPreference : filters) {
            entityReference = this.getOwnerEntityReference(defaultNotificationFilterPreference);
            EntityReference wikiReference = entityReference.extractReference(EntityType.WIKI);
            try {
                if (this.wikiDescriptorManager.exists(wikiReference.getName())) {
                    List<DefaultNotificationFilterPreference> filterPreferenceList;
                    if (filtersToStore.containsKey(entityReference)) {
                        filterPreferenceList = (List)filtersToStore.get(entityReference);
                    } else {
                        filterPreferenceList = new ArrayList();
                        filtersToStore.put(entityReference, filterPreferenceList);
                    }
                    filterPreferenceList.add(new DefaultNotificationFilterPreference(defaultNotificationFilterPreference, false));
                } else {
                    this.logger.warn("Owner [{}] of some filter preferences belongs to a wiki that does not long exist, preferences will be removed.", (Object)entityReference);
                }
            }
            catch (WikiManagerException e) {
                throw new DataMigrationException(String.format("Error when checking existence of wiki [%s]", wikiReference), (Throwable)e);
            }
            internalIds.add(defaultNotificationFilterPreference.getInternalId());
        }
        this.logger.info("Migrating filters for [{}] entities", (Object)filtersToStore.size());
        for (Map.Entry entry : filtersToStore.entrySet()) {
            entityReference = (EntityReference)entry.getKey();
            List notificationFilterPreferenceList = (List)entry.getValue();
            try {
                if (entityReference.getType() == EntityType.DOCUMENT) {
                    this.filterPreferenceStore.saveFilterPreferences(new DocumentReference(entityReference), (Collection<NotificationFilterPreference>)notificationFilterPreferenceList);
                    continue;
                }
                this.filterPreferenceStore.saveFilterPreferences(new WikiReference(entityReference.getName()), (Collection<NotificationFilterPreference>)notificationFilterPreferenceList);
            }
            catch (NotificationException e) {
                throw new DataMigrationException(String.format("Error when trying to save filters to migrate for [%s]", entityReference), (Throwable)e);
            }
        }
        if (!internalIds.isEmpty()) {
            this.getStore().executeWrite(this.getXWikiContext(), session -> session.createQuery(DELETE_FILTER_STATEMENT).setParameter("listIds", (Object)internalIds).executeUpdate());
        }
    }

    private EntityReference getOwnerEntityReference(DefaultNotificationFilterPreference filterPreference) {
        String owner = filterPreference.getOwner();
        EntityReference reference = this.entityReferenceResolver.resolve((Object)owner, EntityType.DOCUMENT, new Object[0]);
        if (reference.extractReference(EntityType.WIKI) == null) {
            reference = this.entityReferenceResolver.resolve((Object)owner, EntityType.WIKI, new Object[0]);
        }
        return reference;
    }
}

