/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.cache.Cache;
import org.xwiki.cache.CacheException;
import org.xwiki.cache.CacheManager;
import org.xwiki.cache.config.CacheConfiguration;
import org.xwiki.cache.config.LRUCacheConfiguration;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.stability.Unstable;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="R151002000XWIKI21448")
@Singleton
@Unstable
public class R151002000XWIKI21448DataMigration
extends AbstractHibernateDataMigration {
    private static final int BATCH_SIZE = 100;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private ConfigurationSource configurationSource;
    @Inject
    private QueryManager queryManager;
    @Inject
    private CacheManager cacheManager;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    @Named(value="count")
    private QueryFilter countQueryFilter;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "Clean up remaining notifications filters that concerns deleted documents";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(151002000);
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        boolean isMainWiki = Objects.equals(this.wikiDescriptorManager.getCurrentWikiId(), this.wikiDescriptorManager.getMainWikiId());
        if (this.useMainStore() && !isMainWiki) {
            return;
        }
        this.internalHibernateMigrate();
    }

    private boolean useMainStore() {
        return (Boolean)this.configurationSource.getProperty("eventstream.usemainstore", (Object)true);
    }

    private void internalHibernateMigrate() throws DataMigrationException {
        Cache documentStatus;
        try {
            documentStatus = this.cacheManager.createNewLocalCache((CacheConfiguration)new LRUCacheConfiguration("migration.R151002000XWIKI21448.documentStatus"));
        }
        catch (CacheException e) {
            throw new DataMigrationException("Cannot create local cache for performing the migration", (Throwable)e);
        }
        String statement = "select distinct nfp.pageOnly from DefaultNotificationFilterPreference nfp where length(nfp.pageOnly) > 0";
        String deletionStatement = "delete from DefaultNotificationFilterPreference where pageOnly IN (:missingDocuments)";
        try {
            List queryResult;
            String latestExistingDocument = null;
            do {
                Object fetchFilterStatement = statement;
                if (!StringUtils.isEmpty(latestExistingDocument)) {
                    fetchFilterStatement = (String)fetchFilterStatement + " AND nfp.pageOnly > :latestExistingDocument";
                }
                fetchFilterStatement = (String)fetchFilterStatement + " order by nfp.pageOnly";
                Query query = this.queryManager.createQuery((String)fetchFilterStatement, "hql");
                if (!StringUtils.isEmpty(latestExistingDocument)) {
                    query = query.bindValue("latestExistingDocument", latestExistingDocument);
                }
                queryResult = query.setLimit(100).execute();
                this.logger.info("Performing filters analysis for [{}] documents", (Object)queryResult.size());
                HashSet<String> deletedDocuments = new HashSet<String>();
                for (String serializedDocument : queryResult) {
                    if (!this.isDocumentExisting(serializedDocument, (Cache<Boolean>)documentStatus)) {
                        deletedDocuments.add(serializedDocument);
                        continue;
                    }
                    latestExistingDocument = serializedDocument;
                }
                this.logger.info("[{}] missing documents found, performing clean up of filters...", (Object)deletedDocuments.size());
                if (deletedDocuments.isEmpty()) continue;
                this.getXWikiContext().getWiki().getHibernateStore().executeWrite(this.getXWikiContext(), session -> session.createQuery(deletionStatement).setParameter("missingDocuments", (Object)deletedDocuments).executeUpdate());
            } while (queryResult.size() == 100);
        }
        catch (QueryException e) {
            throw new DataMigrationException("Error when performing the query to access filters", (Throwable)e);
        }
        catch (XWikiException e) {
            throw new DataMigrationException("Error when performing the query to clean up filters", (Throwable)e);
        }
        finally {
            documentStatus.dispose();
        }
    }

    private boolean isDocumentExisting(String serializedDocument, Cache<Boolean> documentStatus) throws DataMigrationException {
        Boolean status = (Boolean)documentStatus.get(serializedDocument);
        if (status == null) {
            DocumentReference documentReference = this.documentReferenceResolver.resolve((Object)serializedDocument, new Object[0]);
            try {
                if (this.wikiDescriptorManager.exists(documentReference.getWikiReference().getName())) {
                    String compactSerialization = (String)this.entityReferenceSerializer.serialize((EntityReference)documentReference, new Object[0]);
                    String statement = "where doc.fullName = :docName";
                    List result = this.queryManager.createQuery(statement, "xwql").bindValue("docName", (Object)compactSerialization).setLimit(1).setWiki(documentReference.getWikiReference().getName()).addFilter(this.countQueryFilter).execute();
                    status = (Long)result.get(0) > 0L;
                } else {
                    status = false;
                }
                documentStatus.set(serializedDocument, (Object)status);
            }
            catch (Exception e) {
                throw new DataMigrationException(String.format("Error when trying to check if document [%s] exists", serializedDocument), (Throwable)e);
            }
        }
        return status;
    }
}

