/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.migration;

import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.NotificationFilterPreferenceStore;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryFilter;
import org.xwiki.query.QueryManager;
import org.xwiki.user.UserException;
import org.xwiki.user.UserManager;
import org.xwiki.user.UserReference;
import org.xwiki.user.UserReferenceResolver;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
@Named(value="R140401000XWIKI15460")
public class R140401000XWIKI15460DataMigration
extends AbstractHibernateDataMigration {
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NotificationFilterPreferenceStore store;
    @Inject
    private DocumentReferenceResolver<String> resolver;
    @Inject
    @Named(value="document")
    private UserReferenceResolver<DocumentReference> documentReferenceUserReferenceResolver;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private QueryManager queryManager;
    @Inject
    @Named(value="count")
    private QueryFilter countQueryFilter;
    @Inject
    private UserManager userManager;
    @Inject
    private ConfigurationSource configurationSource;

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(140401000);
    }

    public String getDescription() {
        return "Remove the notification filters preferences remaining from removed sub-wikis.";
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        boolean shouldExecute = super.shouldExecute(startupVersion);
        if (shouldExecute) {
            int version = startupVersion.getVersion();
            shouldExecute = version < 131007000 || version >= 140000000;
        }
        return shouldExecute;
    }

    protected void hibernateMigrate() throws DataMigrationException {
        boolean isMainWiki = this.isMainWiki();
        if (this.useMainStore() && !isMainWiki) {
            return;
        }
        this.internalHibernateMigrate(isMainWiki);
    }

    private boolean useMainStore() {
        return (Boolean)this.configurationSource.getProperty("eventstream.usemainstore", (Object)true);
    }

    private void internalHibernateMigrate(boolean isMainWiki) throws DataMigrationException {
        try {
            Collection<Object> knownWikiIds = isMainWiki ? this.wikiDescriptorManager.getAllIds() : Collections.emptyList();
            HashSet<String> unknownWikiIds = new HashSet<String>();
            HashMap<String, Boolean> usersStatus = new HashMap<String, Boolean>();
            int limit = 1000;
            int offset = 0;
            Set<DefaultNotificationFilterPreference> allNotificationFilterPreferences = this.store.getPaginatedFilterPreferences(limit, offset);
            while (!allNotificationFilterPreferences.isEmpty()) {
                for (DefaultNotificationFilterPreference filterPreference : allNotificationFilterPreferences) {
                    if (isMainWiki) {
                        this.identifyRemovedWikis(knownWikiIds, unknownWikiIds, filterPreference);
                    }
                    this.identifyRemovedUsers(usersStatus, filterPreference);
                }
                allNotificationFilterPreferences = this.store.getPaginatedFilterPreferences(limit, offset += limit);
            }
            for (String unknownWikiId : unknownWikiIds) {
                this.store.deleteFilterPreference(new WikiReference(unknownWikiId));
            }
            Set unknownUsers = usersStatus.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).collect(Collectors.toSet());
            for (String userReference : unknownUsers) {
                DocumentReference userDocumentReference = this.resolver.resolve((Object)userReference, new Object[0]);
                if (this.store.getPreferencesOfUser(userDocumentReference).isEmpty()) continue;
                this.store.deleteFilterPreferences(userDocumentReference);
            }
        }
        catch (NotificationException e) {
            throw new DataMigrationException("Failed to retrieve the notification filters preferences.", (Throwable)e);
        }
        catch (WikiManagerException e) {
            throw new DataMigrationException("Failed to retrieve the ids of wikis of the farm.", (Throwable)e);
        }
    }

    private void identifyRemovedWikis(Collection<String> knownWikiIds, Set<String> unknownWikiIds, DefaultNotificationFilterPreference filterPreference) {
        filterPreference.getWikiId().ifPresent(wikiId -> {
            if (!knownWikiIds.contains(wikiId)) {
                unknownWikiIds.add((String)wikiId);
            }
        });
    }

    private void identifyRemovedUsers(Map<String, Boolean> usersStatus, DefaultNotificationFilterPreference filterPreference) throws DataMigrationException {
        String owner = filterPreference.getOwner();
        WikiReference currentWiki = this.getXWikiContext().getWikiReference();
        AtomicReference exception = new AtomicReference();
        usersStatus.computeIfAbsent(owner, key -> {
            DocumentReference entityReference = this.resolver.resolve(key, new Object[0]);
            WikiReference wikiReference = entityReference.getWikiReference();
            try {
                if (wikiReference.equals((Object)currentWiki)) {
                    UserReference userReference = this.documentReferenceUserReferenceResolver.resolve((Object)entityReference, new Object[0]);
                    return this.userManager.exists(userReference);
                }
                if (!this.wikiDescriptorManager.exists(wikiReference.getName())) {
                    return false;
                }
                String serializedName = (String)this.entityReferenceSerializer.serialize((EntityReference)entityReference, new Object[0]);
                String statement = ", BaseObject as obj where doc.fullName = :username and doc.fullName = obj.name and obj.className = 'XWiki.XWikiUsers'";
                List result = this.queryManager.createQuery(statement, "hql").setWiki(wikiReference.getName()).bindValue("username", (Object)serializedName).addFilter(this.countQueryFilter).setLimit(1).execute();
                return (Long)result.get(0) > 0L;
            }
            catch (QueryException | UserException | WikiManagerException e) {
                exception.set(e);
                return null;
            }
        });
        if (exception.get() != null) {
            throw new DataMigrationException(String.format("Failed to identify if the owner of [%s] exists.", filterPreference), (Throwable)exception.get());
        }
    }

    private boolean isMainWiki() {
        return Objects.equals(this.wikiDescriptorManager.getCurrentWikiId(), this.wikiDescriptorManager.getMainWikiId());
    }
}

