/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.migrators;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.store.migration.DataMigrationException;
import com.xpn.xwiki.store.migration.XWikiDBVersion;
import com.xpn.xwiki.store.migration.hibernate.AbstractHibernateDataMigration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;

@Component
@Named(value="R98000NotificationPreferenceScopeMigration")
@Singleton
public class ScopeNotificationFilterClassMigrator
extends AbstractHibernateDataMigration {
    private static final List<String> NOTIFICATION_CODE_PATH = Arrays.asList("XWiki", "Notifications", "Code");
    private static final LocalDocumentReference OLD_XCLASS_REFERENCE = new LocalDocumentReference(NOTIFICATION_CODE_PATH, "NotificationPreferenceScopeClass");
    private static final LocalDocumentReference NEW_XCLASS_REFERENCE = new LocalDocumentReference(NOTIFICATION_CODE_PATH, "NotificationFilterPreferenceClass");
    @Inject
    private QueryManager queryManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> resolver;
    @Inject
    private Logger logger;

    public String getDescription() {
        return "Move old NotificationPreferenceScopeClass XObjects to the more generic NotificationFilterPreferenceClass XObjects.";
    }

    public XWikiDBVersion getVersion() {
        return new XWikiDBVersion(98000);
    }

    public boolean shouldExecute(XWikiDBVersion startupVersion) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        DocumentReference classReference = this.getOldClassReference();
        try {
            return context.getWiki().exists(classReference, context);
        }
        catch (XWikiException e) {
            this.logger.warn("Failed to check the existence of the class with reference [{}]: {}", (Object)classReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return true;
        }
    }

    protected void hibernateMigrate() throws DataMigrationException, XWikiException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWiki xwiki = context.getWiki();
        try {
            Query query = this.queryManager.createQuery("select distinct doc.fullName from Document doc, doc.object(XWiki.Notifications.Code.NotificationPreferenceScopeClass) as obj", "xwql");
            for (String result : query.execute()) {
                DocumentReference userReference = this.resolver.resolve((Object)result, new Object[0]);
                XWikiDocument userDocument = xwiki.getDocument(userReference, context);
                this.logger.debug("Migrating document [{}]...", (Object)result);
                try {
                    this.migrateDocument(userDocument);
                }
                catch (XWikiException e) {
                    this.logger.warn("Failed to migrate document [{}].", (Object)result, (Object)e);
                }
            }
        }
        catch (QueryException e) {
            this.logger.error("Failed to perform a query on the current wiki.", (Throwable)e);
        }
    }

    private void migrateDocument(XWikiDocument document) throws XWikiException {
        DocumentReference oldClassReference = this.getOldClassReference();
        List oldXObjects = document.getXObjects(oldClassReference);
        for (BaseObject oldXObject : oldXObjects) {
            if (oldXObject == null) continue;
            document.addXObject(this.generateNewXObject(oldXObject));
        }
        document.removeXObjects(oldClassReference);
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        context.getWiki().saveDocument(document, "[UPGRADE] XObject migration from ScopeNotificationFilterClass to NotificationPreferenceFilterClass.", context);
    }

    private BaseObject generateNewXObject(BaseObject oldXObject) {
        BaseObject newXObject = new BaseObject();
        newXObject.setXClassReference((EntityReference)NEW_XCLASS_REFERENCE);
        String oldEventType = oldXObject.getStringValue("eventType");
        String oldFilterFormat = oldXObject.getStringValue("format");
        String oldFilterType = oldXObject.getStringValue("scopeFilterType");
        String oldScopeReferenceValue = oldXObject.getStringValue("scopeReference");
        String oldScopeValue = oldXObject.getStringValue("scope");
        newXObject.setStringValue("filterPreferenceName", String.format("scopeNotificationFilter-%s-%s-%s-%s-%s", oldEventType, oldFilterFormat, oldFilterType, oldScopeValue, oldScopeReferenceValue));
        newXObject.setStringValue("filterName", "scopeNotificationFilter");
        newXObject.setStringValue("filterType", oldFilterType);
        newXObject.setStringListValue("filterFormats", Collections.singletonList(oldFilterFormat));
        List<String> oldXObjectScopeReference = Collections.singletonList(oldScopeReferenceValue);
        switch (oldScopeValue) {
            case "pageOnly": {
                newXObject.setStringListValue("pages", oldXObjectScopeReference);
                break;
            }
            case "pageAndChildren": {
                newXObject.setStringListValue("spaces", oldXObjectScopeReference);
                break;
            }
            case "wiki": {
                newXObject.setStringListValue("wikis", oldXObjectScopeReference);
                break;
            }
        }
        return newXObject;
    }

    private DocumentReference getOldClassReference() {
        return new DocumentReference(OLD_XCLASS_REFERENCE, ((XWikiContext)this.contextProvider.get()).getWikiReference());
    }
}

