/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata.system;

import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilter;
import org.xwiki.notifications.filters.internal.ToggleableNotificationFilterActivation;
import org.xwiki.notifications.filters.internal.livedata.AbstractNotificationFilterLiveDataEntryStore;

@Component
@Singleton
@Named(value="notificationSystemFilters")
public class NotificationSystemFiltersLiveDataEntryStore
extends AbstractNotificationFilterLiveDataEntryStore {
    private static final LocalDocumentReference NOTIFICATION_ADMINISTRATION_REF = new LocalDocumentReference(List.of("XWiki", "Notifications", "Code"), "NotificationAdministration");
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    private FilterPreferencesModelBridge filterPreferencesModelBridge;

    public Optional<Map<String, Object>> get(Object entryId) throws LiveDataException {
        return Optional.empty();
    }

    private Map<String, Object> getPreferencesInformation(ToggleableNotificationFilter notificationFilter, ToggleableNotificationFilterActivation filterActivation) {
        return Map.of("name", this.translationHelper.getTranslationWithPrefix("notifications.filters.name.", notificationFilter.getName()), "filterDescription", this.translationHelper.getTranslationWithPrefix("notifications.filters.description.", notificationFilter.getName()), "notificationFormats", this.displayNotificationFormats(notificationFilter.getFormats()), "isEnabled_data", this.displayIsEnabledData((NotificationFilter)notificationFilter, filterActivation), "isEnabled_checked", this.isEnabled(notificationFilter, filterActivation));
    }

    private String getObjectNumber(ToggleableNotificationFilterActivation filterActivation) {
        return filterActivation != null && filterActivation.getObjectNumber() != -1 ? String.valueOf(filterActivation.getObjectNumber()) : "";
    }

    private Map<String, String> displayIsEnabledData(NotificationFilter notificationFilter, ToggleableNotificationFilterActivation filterActivation) {
        return Map.of("objectNumber", this.getObjectNumber(filterActivation), "filterName", notificationFilter.getName());
    }

    private boolean isEnabled(ToggleableNotificationFilter notificationFilter, ToggleableNotificationFilterActivation filterActivation) {
        return filterActivation != null && filterActivation.isEnabled() || filterActivation == null && notificationFilter.isEnabledByDefault();
    }

    public LiveData get(LiveDataQuery query) throws LiveDataException {
        Map filtersActivations;
        Collection notificationFilters;
        AbstractNotificationFilterLiveDataEntryStore.TargetInformation targetInformation = this.getTargetInformation(query);
        try {
            if (targetInformation.isWikiTarget()) {
                WikiReference wikiReference = new WikiReference(targetInformation.getOwnerReference());
                notificationFilters = this.notificationFilterManager.getAllFilters(wikiReference);
                filtersActivations = this.filterPreferencesModelBridge.getToggleableFilterActivations(new DocumentReference(NOTIFICATION_ADMINISTRATION_REF, wikiReference));
            } else {
                DocumentReference userDoc = new DocumentReference(targetInformation.getOwnerReference());
                notificationFilters = this.notificationFilterManager.getAllFilters(userDoc, false);
                filtersActivations = this.filterPreferencesModelBridge.getToggleableFilterActivations(userDoc);
            }
        }
        catch (NotificationException e) {
            throw new LiveDataException("Error when getting list of filters", (Throwable)e);
        }
        List<ToggleableNotificationFilter> allFilters = notificationFilters.stream().filter(filter -> filter instanceof ToggleableNotificationFilter).map(item -> (ToggleableNotificationFilter)item).toList();
        int totalFilters = allFilters.size();
        LiveData liveData = new LiveData();
        liveData.setCount((long)totalFilters);
        List entries = liveData.getEntries();
        allFilters.stream().sorted(Comparator.comparing(NotificationFilter::getName)).skip(query.getOffset()).limit(query.getLimit().intValue()).forEach(filter -> entries.add(this.getPreferencesInformation((ToggleableNotificationFilter)filter, (ToggleableNotificationFilterActivation)filtersActivations.get(filter.getName()))));
        return liveData;
    }
}

