/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata.custom;

import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterManager;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.NotificationFilterPreferenceStore;
import org.xwiki.notifications.filters.internal.livedata.AbstractNotificationFilterLiveDataEntryStore;
import org.xwiki.notifications.filters.internal.livedata.custom.NotificationCustomFiltersLiveDataConfigurationProvider;
import org.xwiki.notifications.filters.internal.livedata.custom.NotificationCustomFiltersQueryHelper;
import org.xwiki.query.QueryException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="notificationCustomFilters")
public class NotificationCustomFiltersLiveDataEntryStore
extends AbstractNotificationFilterLiveDataEntryStore {
    private static final String WIKI = "wiki";
    private static final String LOCATION_TEMPLATE = "notification/filters/livedatalocation.vm";
    @Inject
    private NotificationFilterPreferenceStore notificationFilterPreferenceStore;
    @Inject
    private NotificationFilterManager notificationFilterManager;
    @Inject
    @Named(value="context")
    private ComponentManager componentManager;
    @Inject
    @Named(value="html/5.0")
    private BlockRenderer blockRenderer;
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private NotificationCustomFiltersQueryHelper queryHelper;

    public Optional<Map<String, Object>> get(Object entryId) throws LiveDataException {
        Optional<Map<String, Object>> result = Optional.empty();
        try {
            Optional<NotificationFilterPreference> filterPreferenceOpt = this.notificationFilterPreferenceStore.getFilterPreference(String.valueOf(entryId), this.getCurrentWikiReference());
            if (filterPreferenceOpt.isPresent()) {
                DefaultNotificationFilterPreference filterPreference = (DefaultNotificationFilterPreference)filterPreferenceOpt.get();
                this.checkAccessFilterPreference(filterPreference);
                result = Optional.of(this.getPreferenceInformation(filterPreference));
            }
        }
        catch (NotificationException e) {
            throw new LiveDataException(String.format("Error while retrieving LiveData entry for notification filter with id [%s]", entryId), (Throwable)e);
        }
        return result;
    }

    private Map<String, Object> getPreferenceInformation(NotificationFilterPreference filterPreference) throws LiveDataException {
        NotificationCustomFiltersLiveDataConfigurationProvider.Scope scope = this.getScope(filterPreference);
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("filterPreferenceId", filterPreference.getId());
        result.put("eventTypes", this.displayEventTypes(filterPreference));
        result.put("notificationFormats", this.displayNotificationFormats(filterPreference.getNotificationFormats()));
        result.put("scope", this.getScopeInfo(scope));
        result.put("location", this.displayLocation(filterPreference, scope));
        result.put("display", this.renderDisplay(filterPreference));
        result.put("filterType", this.translationHelper.getFilterTypeTranslation(filterPreference.getFilterType()));
        result.put("isEnabled_checked", filterPreference.isEnabled());
        result.put("isEnabled_disabled", filterPreference.getId().startsWith("watchlist_"));
        result.put("isEnabled_data", Map.of("preferenceId", filterPreference.getId()));
        result.put("doc_hasdelete", true);
        return result;
    }

    private String displayLocation(NotificationFilterPreference filterPreference, NotificationCustomFiltersLiveDataConfigurationProvider.Scope scope) {
        EntityReference location = switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.USER -> this.entityReferenceResolver.resolve((Object)filterPreference.getUser(), EntityType.DOCUMENT, new Object[0]);
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.WIKI -> this.entityReferenceResolver.resolve((Object)filterPreference.getWiki(), EntityType.WIKI, new Object[0]);
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.SPACE -> this.entityReferenceResolver.resolve((Object)filterPreference.getPage(), EntityType.SPACE, new Object[0]);
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.PAGE -> this.entityReferenceResolver.resolve((Object)filterPreference.getPageOnly(), EntityType.DOCUMENT, new Object[0]);
        };
        ScriptContext currentScriptContext = this.scriptContextManager.getCurrentScriptContext();
        currentScriptContext.setAttribute("location", location, 100);
        return this.templateManager.renderNoException(LOCATION_TEMPLATE);
    }

    private Map<String, Object> displayEventTypes(NotificationFilterPreference filterPreference) {
        List<String> items = filterPreference.getEventTypes().isEmpty() ? List.of(this.translationHelper.getAllEventTypesTranslation()) : filterPreference.getEventTypes().stream().sorted(Comparator.naturalOrder()).map(eventType -> this.translationHelper.getEventTypeTranslation((String)eventType)).toList();
        return this.getStaticListInfo(items);
    }

    private Map<String, String> getScopeInfo(NotificationCustomFiltersLiveDataConfigurationProvider.Scope scope) {
        String icon = switch (scope) {
            default -> throw new IncompatibleClassChangeError();
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.USER -> "user";
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.WIKI -> WIKI;
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.SPACE -> "chart-organisation";
            case NotificationCustomFiltersLiveDataConfigurationProvider.Scope.PAGE -> "page";
        };
        return Map.of("icon", icon, "name", this.translationHelper.getScopeTranslation(scope));
    }

    private String renderDisplay(NotificationFilterPreference filterPreference) throws LiveDataException {
        String result = "";
        DefaultWikiPrinter printer = new DefaultWikiPrinter();
        String missingComponentExceptionMessage = String.format("Cannot find NotificationFilter component for preference named [%s]", filterPreference.getFilterName());
        if (this.componentManager.hasComponent(NotificationFilter.class, filterPreference.getFilterName())) {
            try {
                NotificationFilter filter = (NotificationFilter)this.componentManager.getInstance(NotificationFilter.class, filterPreference.getFilterName());
                Block block = this.notificationFilterManager.displayFilter(filter, filterPreference);
                this.blockRenderer.render(block, (WikiPrinter)printer);
                result = printer.toString();
            }
            catch (Exception e) {
                throw new LiveDataException("Error while rendering a block for notification filter", (Throwable)e);
            }
        } else {
            throw new LiveDataException(missingComponentExceptionMessage);
        }
        return result;
    }

    private NotificationCustomFiltersLiveDataConfigurationProvider.Scope getScope(NotificationFilterPreference filterPreference) {
        if (!StringUtils.isBlank((CharSequence)filterPreference.getUser())) {
            return NotificationCustomFiltersLiveDataConfigurationProvider.Scope.USER;
        }
        if (!StringUtils.isBlank((CharSequence)filterPreference.getPageOnly())) {
            return NotificationCustomFiltersLiveDataConfigurationProvider.Scope.PAGE;
        }
        if (!StringUtils.isBlank((CharSequence)filterPreference.getPage())) {
            return NotificationCustomFiltersLiveDataConfigurationProvider.Scope.SPACE;
        }
        return NotificationCustomFiltersLiveDataConfigurationProvider.Scope.WIKI;
    }

    public LiveData get(LiveDataQuery query) throws LiveDataException {
        if (query.getOffset() > Integer.MAX_VALUE) {
            throw new LiveDataException("Currently only integer offsets are supported.");
        }
        AbstractNotificationFilterLiveDataEntryStore.TargetInformation targetInformation = this.getTargetInformation(query);
        String serializedOwner = (String)this.entityReferenceSerializer.serialize(targetInformation.getOwnerReference(), new Object[0]);
        WikiReference wikiReference = new WikiReference(targetInformation.getOwnerReference().extractReference(EntityType.WIKI));
        LiveData liveData = new LiveData();
        try {
            long filterCount = this.queryHelper.countTotalFilters(query, serializedOwner, wikiReference);
            List<NotificationFilterPreference> filterPreferences = this.queryHelper.getFilterPreferences(query, serializedOwner, wikiReference);
            liveData.setCount(filterCount);
            List entries = liveData.getEntries();
            for (NotificationFilterPreference notificationFilterPreference : filterPreferences) {
                entries.add(this.getPreferenceInformation(notificationFilterPreference));
            }
        }
        catch (QueryException e) {
            throw new LiveDataException("Error when querying notification filter preferences", (Throwable)e);
        }
        return liveData;
    }
}

