/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.EventStreamException;
import org.xwiki.eventstream.RecordableEventDescriptor;
import org.xwiki.eventstream.RecordableEventDescriptorManager;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.notifications.filters.internal.livedata.custom.NotificationCustomFiltersLiveDataConfigurationProvider;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component(roles={NotificationFilterLiveDataTranslationHelper.class})
@Singleton
public class NotificationFilterLiveDataTranslationHelper {
    @Inject
    private ContextualLocalizationManager contextualLocalizationManager;
    @Inject
    private RecordableEventDescriptorManager recordableEventDescriptorManager;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private Logger logger;

    private String getTranslationWithFallback(String translationKey) {
        String translationPlain = this.contextualLocalizationManager.getTranslationPlain(translationKey, new Object[0]);
        if (translationPlain == null) {
            translationPlain = translationKey;
        }
        return translationPlain;
    }

    public String getTranslationWithPrefix(String prefix, String key) {
        return this.getTranslationWithFallback(prefix + key);
    }

    public String getFilterTypeTranslation(NotificationFilterType filterType) {
        return this.getTranslationWithPrefix("notifications.filters.type.custom.", filterType.name().toLowerCase());
    }

    public String getScopeTranslation(NotificationCustomFiltersLiveDataConfigurationProvider.Scope scope) {
        return this.getTranslationWithPrefix("notifications.filters.preferences.scopeNotificationFilter.", scope.name().toLowerCase());
    }

    public String getAllEventTypesTranslation() {
        return this.getTranslationWithFallback("notifications.filters.preferences.allEvents");
    }

    public String getEventTypeTranslation(String eventType) {
        String result = eventType;
        try {
            RecordableEventDescriptor descriptor = this.recordableEventDescriptorManager.getDescriptorForEventType(eventType, true);
            if (descriptor != null) {
                result = this.getTranslationWithFallback(descriptor.getDescription());
            }
        }
        catch (EventStreamException e) {
            this.logger.error("Error while getting description for event type [{}] falling back on event name", (Object)eventType, (Object)e);
        }
        return result;
    }

    public String getFormatTranslation(NotificationFormat format) {
        return this.getTranslationWithPrefix("notifications.format.", format.name().toLowerCase());
    }

    public List<Map<String, String>> getAllEventTypesOptions() throws LiveDataException {
        try {
            boolean isMainWiki = this.wikiDescriptorManager.isMainWiki(this.wikiDescriptorManager.getCurrentWikiId());
            List recordableEventDescriptors = this.recordableEventDescriptorManager.getRecordableEventDescriptors(isMainWiki);
            return recordableEventDescriptors.stream().map(descriptor -> Map.of("value", descriptor.getEventType(), "label", this.getTranslationWithFallback(descriptor.getDescription()))).collect(Collectors.toList());
        }
        catch (EventStreamException e) {
            throw new LiveDataException("Error while retrieving event descriptors", (Throwable)e);
        }
    }
}

