/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.livedata;

import com.xpn.xwiki.XWikiContext;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Provider;
import org.xwiki.livedata.LiveDataEntryStore;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.livedata.NotificationFilterLiveDataTranslationHelper;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractNotificationFilterLiveDataEntryStore
implements LiveDataEntryStore {
    private static final String TARGET_SOURCE_PARAMETER = "target";
    private static final String WIKI_SOURCE_PARAMETER = "wiki";
    private static final String UNAUTHORIZED_EXCEPTION_MSG = "You don't have rights to access those information.";
    @Inject
    protected NotificationFilterLiveDataTranslationHelper translationHelper;
    @Inject
    protected EntityReferenceResolver<String> entityReferenceResolver;
    @Inject
    protected EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;

    protected Map<String, Object> getStaticListInfo(List<String> items) {
        return Map.of("extraClass", "list-unstyled", "items", items);
    }

    protected Map<String, Object> displayNotificationFormats(Collection<NotificationFormat> notificationFormats) {
        List<String> items = notificationFormats.stream().sorted(Comparator.comparing(Enum::name)).map(notificationFormat -> this.translationHelper.getFormatTranslation((NotificationFormat)notificationFormat)).toList();
        return this.getStaticListInfo(items);
    }

    protected TargetInformation getTargetInformation(LiveDataQuery query) throws LiveDataException {
        Map sourceParameters = query.getSource().getParameters();
        if (!sourceParameters.containsKey(TARGET_SOURCE_PARAMETER)) {
            throw new LiveDataException("The target source parameter is mandatory.");
        }
        String target = String.valueOf(sourceParameters.get(TARGET_SOURCE_PARAMETER));
        TargetInformation result = new TargetInformation();
        if (WIKI_SOURCE_PARAMETER.equals(target)) {
            result.isWikiTarget = true;
            result.ownerReference = this.entityReferenceResolver.resolve((Object)String.valueOf(sourceParameters.get(WIKI_SOURCE_PARAMETER)), EntityType.WIKI, new Object[0]);
        } else {
            result.isWikiTarget = false;
            result.ownerReference = this.entityReferenceResolver.resolve((Object)String.valueOf(sourceParameters.get(target)), EntityType.DOCUMENT, new Object[0]);
        }
        if (!this.contextualAuthorizationManager.hasAccess(Right.ADMIN) && !result.ownerReference.equals((Object)this.getCurrentUserReference())) {
            throw new LiveDataException(UNAUTHORIZED_EXCEPTION_MSG);
        }
        return result;
    }

    protected WikiReference getCurrentWikiReference() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        return context.getWikiReference();
    }

    private DocumentReference getCurrentUserReference() {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        return context.getUserReference();
    }

    protected void checkAccessFilterPreference(DefaultNotificationFilterPreference filterPreference) throws LiveDataException {
        if (!this.contextualAuthorizationManager.hasAccess(Right.ADMIN) && !Objects.equals(filterPreference.getOwner(), this.entityReferenceSerializer.serialize((EntityReference)this.getCurrentUserReference(), new Object[0]))) {
            throw new LiveDataException(UNAUTHORIZED_EXCEPTION_MSG);
        }
    }

    protected static final class TargetInformation {
        private boolean isWikiTarget;
        private EntityReference ownerReference;

        protected TargetInformation() {
        }

        public boolean isWikiTarget() {
            return this.isWikiTarget;
        }

        public EntityReference getOwnerReference() {
            return this.ownerReference;
        }
    }
}

