/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal.event;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.event.NotificationFilterPreferenceAddOrUpdatedEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;

@Component
@Singleton
@Named(value="notificationfilterpreference")
public class NotificationFilterPreferenceEventConverter
extends AbstractEventConverter {
    private static final Set<Class<? extends Event>> EVENTS = Set.of(NotificationFilterPreferenceAddOrUpdatedEvent.class);
    private static final String PROP_OWNER = "owner";

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setSource(this.serializePreference(localEvent.getSource()));
            return true;
        }
        return false;
    }

    private Serializable serializePreference(Object local) {
        Serializable remote = null;
        if (local instanceof DefaultNotificationFilterPreference) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(PROP_OWNER, ((DefaultNotificationFilterPreference)local).getOwner());
            remote = map;
        }
        return remote;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            localEvent.setEvent((Event)remoteEvent.getEvent());
            localEvent.setSource(this.unserializePreference(remoteEvent.getSource()));
            return true;
        }
        return false;
    }

    private Object unserializePreference(Serializable remote) {
        if (remote instanceof Map) {
            Map map = (Map)((Object)remote);
            DefaultNotificationFilterPreference local = new DefaultNotificationFilterPreference();
            local.setOwner((String)map.get(PROP_OWNER));
            return local;
        }
        return null;
    }
}

