/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentException;
import org.xwiki.component.wiki.internal.bridge.WikiBaseObjectComponentBuilder;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.internal.WikiNotificationFilterDisplayer;
import org.xwiki.security.authorization.DocumentAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="XWiki.Notifications.Code.NotificationFilterDisplayerClass")
@Singleton
public class WikiNotificationFilterDisplayerComponentBuilder
implements WikiBaseObjectComponentBuilder {
    @Inject
    private DocumentAuthorizationManager authorizationManager;
    @Inject
    private Provider<WikiNotificationFilterDisplayer> wikiNotificationFilterDisplayerProvider;

    public List<WikiComponent> buildComponents(BaseObject baseObject) throws WikiComponentException {
        try {
            XWikiDocument parentDocument = baseObject.getOwnerDocument();
            this.checkRights(parentDocument.getDocumentReference(), parentDocument.getAuthorReference());
            WikiNotificationFilterDisplayer wikiNotificationFilterDisplayer = (WikiNotificationFilterDisplayer)((Object)this.wikiNotificationFilterDisplayerProvider.get());
            wikiNotificationFilterDisplayer.initialize(parentDocument.getAuthorReference(), baseObject);
            return List.of(wikiNotificationFilterDisplayer);
        }
        catch (Exception e) {
            throw new WikiComponentException(String.format("Unable to build the WikiNotificationFilterDisplayer wiki component for [%s].", baseObject), (Throwable)e);
        }
    }

    public EntityReference getClassReference() {
        return new EntityReference("XWiki.Notifications.Code.NotificationFilterDisplayerClass", EntityType.OBJECT);
    }

    private void checkRights(DocumentReference documentReference, DocumentReference authorReference) throws NotificationException {
        if (!this.authorizationManager.hasAccess(Right.ADMIN, EntityType.WIKI, authorReference, documentReference)) {
            throw new NotificationException("Registering custom Notification Filter Displayers requires wiki administration rights.");
        }
    }
}

