/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.BaseObjectReference;
import com.xpn.xwiki.objects.BaseProperty;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.wiki.WikiComponent;
import org.xwiki.component.wiki.WikiComponentScope;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilter;
import org.xwiki.notifications.filters.NotificationFilterDisplayer;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.AbstractNotificationFilterDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.Template;
import org.xwiki.template.TemplateManager;
import org.xwiki.text.StringUtils;

@Component(roles={WikiNotificationFilterDisplayer.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class WikiNotificationFilterDisplayer
extends AbstractNotificationFilterDisplayer
implements WikiComponent {
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private NotificationFilterDisplayer notificationFilterDisplayer;
    private BaseObjectReference objectReference;
    private DocumentReference authorReference;
    private Template filterTemplate;
    private Set<String> supportedFilters;
    private String componentHint;

    public void initialize(DocumentReference authorReference, BaseObject baseObject) throws NotificationException {
        this.objectReference = (BaseObjectReference)baseObject.getReference();
        this.authorReference = authorReference;
        try {
            String xObjectTemplate;
            this.supportedFilters = new HashSet<String>(baseObject.getListValue("supportedFilters"));
            this.componentHint = this.generateComponentHint();
            this.filterTemplate = null;
            BaseProperty property = (BaseProperty)baseObject.get("filterTemplate");
            if (property != null && property.getValue() != null && !StringUtils.isBlank((CharSequence)(xObjectTemplate = property.getValue().toString()))) {
                this.filterTemplate = this.templateManager.createStringTemplate((String)this.serializer.serialize(property.getReference(), new Object[0]), xObjectTemplate, this.getAuthorReference(), baseObject.getDocumentReference());
            }
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to initialize a new WikiNotificationFilterDisplayer from the base object [%s]", baseObject), (Throwable)e);
        }
    }

    private String generateComponentHint() {
        Iterator<String> it = this.supportedFilters.iterator();
        StringBuilder builder = new StringBuilder();
        while (it.hasNext()) {
            builder.append(String.format("%s-", it.next()));
        }
        builder.append("wikiComponent");
        return builder.toString();
    }

    public Block display(NotificationFilter filter, NotificationFilterPreference preference) throws NotificationException {
        Map backup = this.setUpContext(this.scriptContextManager, filter, preference);
        try {
            if (this.filterTemplate == null) {
                Block block = this.notificationFilterDisplayer.display(filter, preference);
                return block;
            }
            XDOM xDOM = this.templateManager.execute(this.filterTemplate);
            return xDOM;
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Unable to display the notification filter template for the filters [%s].", this.componentHint), (Throwable)e);
        }
        finally {
            this.cleanUpContext(this.scriptContextManager, backup);
        }
    }

    public Set<String> getSupportedFilters() {
        return this.supportedFilters;
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.objectReference.getParent();
    }

    public EntityReference getEntityReference() {
        return this.objectReference;
    }

    public DocumentReference getAuthorReference() {
        return this.authorReference;
    }

    public Type getRoleType() {
        return NotificationFilterDisplayer.class;
    }

    public String getRoleHint() {
        return this.componentHint;
    }

    public WikiComponentScope getScope() {
        return WikiComponentScope.WIKI;
    }
}

