/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.internal.DefaultNotificationFilterPreference;
import org.xwiki.notifications.filters.internal.event.NotificationFilterPreferenceAddOrUpdatedEvent;
import org.xwiki.notifications.filters.internal.event.NotificationFilterPreferenceDeletedEvent;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.query.Query;
import org.xwiki.query.QueryException;
import org.xwiki.query.QueryManager;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component(roles={NotificationFilterPreferenceStore.class})
@Singleton
public class NotificationFilterPreferenceStore {
    private static final String ID = "id";
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private QueryManager queryManager;
    @Inject
    private ObservationManager observation;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    public Optional<NotificationFilterPreference> getFilterPreference(String filterPreferenceId, WikiReference wikiReference) throws NotificationException {
        Optional<NotificationFilterPreference> result = Optional.empty();
        DefaultNotificationFilterPreference filterPreference = this.configureContextWrapper(wikiReference, () -> {
            try {
                Query query = this.queryManager.createQuery("select nfp from DefaultNotificationFilterPreference nfp where nfp.id = :id", "hql");
                query.setLimit(1);
                query.bindValue(ID, (Object)filterPreferenceId);
                List results = query.execute();
                if (!results.isEmpty()) {
                    return (DefaultNotificationFilterPreference)results.get(0);
                }
            }
            catch (QueryException e) {
                throw new NotificationException(String.format("Error while retrieving notification with id [%s]", filterPreferenceId), (Throwable)e);
            }
            return null;
        });
        if (filterPreference != null) {
            result = Optional.of(filterPreference);
        }
        return result;
    }

    public NotificationFilterPreference getFilterPreference(DocumentReference user, String filterPreferenceId) throws NotificationException {
        for (NotificationFilterPreference notificationFilterPreference : this.getPreferencesOfUser(user)) {
            if (!Strings.CS.equals(notificationFilterPreference.getId(), filterPreferenceId)) continue;
            return notificationFilterPreference;
        }
        return null;
    }

    public NotificationFilterPreference getFilterPreference(WikiReference wikiReference, String filterPreferenceId) throws NotificationException {
        for (NotificationFilterPreference notificationFilterPreference : this.getPreferencesOfWiki(wikiReference)) {
            if (!Strings.CS.equals(notificationFilterPreference.getId(), filterPreferenceId)) continue;
            return notificationFilterPreference;
        }
        return null;
    }

    public List<DefaultNotificationFilterPreference> getPreferencesOfUser(DocumentReference user) throws NotificationException {
        try {
            return this.getPreferencesOfEntity((EntityReference)user);
        }
        catch (QueryException e) {
            throw new NotificationException(String.format("Error while loading the notification filter preferences of the user [%s].", user.toString()), (Throwable)e);
        }
    }

    public List<DefaultNotificationFilterPreference> getPreferencesOfWiki(WikiReference wikiReference) throws NotificationException {
        try {
            return this.getPreferencesOfEntity((EntityReference)wikiReference);
        }
        catch (QueryException e) {
            throw new NotificationException(String.format("Error while loading the notification filter preferences of the wiki [%s].", wikiReference.getName()), (Throwable)e);
        }
    }

    public Set<DefaultNotificationFilterPreference> getPaginatedFilterPreferences(int limit, int offset) throws NotificationException {
        return this.configureContextWrapper(null, () -> {
            try {
                List list = this.queryManager.createQuery("select nfp from DefaultNotificationFilterPreference nfp order by nfp.internalId", "hql").setLimit(limit).setOffset(offset).execute();
                return new HashSet(list);
            }
            catch (QueryException e) {
                String message = String.format("Error while loading all the notification filter preferences on wiki [%s].", ((XWikiContext)this.contextProvider.get()).getWikiId());
                throw new NotificationException(message, (Throwable)e);
            }
        });
    }

    private List<DefaultNotificationFilterPreference> getPreferencesOfEntity(EntityReference entityReference) throws QueryException {
        if (entityReference == null) {
            return Collections.emptyList();
        }
        WikiReference wikiReference = (WikiReference)entityReference.extractReference(EntityType.WIKI);
        return this.configureContextWrapper(wikiReference, () -> {
            String serializedEntity = (String)this.entityReferenceSerializer.serialize(entityReference, new Object[0]);
            Query query = this.queryManager.createQuery("select nfp from DefaultNotificationFilterPreference nfp where nfp.owner = :owner order by nfp.id", "hql");
            query.bindValue("owner", (Object)serializedEntity);
            return query.execute();
        });
    }

    public void deleteFilterPreference(DocumentReference user, String filterPreferenceId) throws NotificationException {
        this.deleteFilterPreferences(user, Set.of(filterPreferenceId));
    }

    public void deleteFilterPreferences(DocumentReference user, Set<String> filterPreferenceIds) throws NotificationException {
        HashSet<Long> filterPreferenceInternalIds = new HashSet<Long>();
        for (String filterPreferenceId : filterPreferenceIds) {
            filterPreferenceInternalIds.add(this.getInternalIdFromId(filterPreferenceId));
        }
        this.deleteFilterPreferences(user.getWikiReference(), filterPreferenceInternalIds);
        this.observation.notify((Event)new NotificationFilterPreferenceDeletedEvent(), (Object)user, filterPreferenceIds);
    }

    public void deleteFilterPreferences(DocumentReference user) throws NotificationException {
        this.configureContextWrapper(user.getWikiReference(), () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            String serializedUser = (String)this.entityReferenceSerializer.serialize((EntityReference)user, new Object[0]);
            try {
                hibernateStore.executeWrite(context, session -> {
                    session.createQuery("delete from DefaultNotificationFilterPreference where owner = :user or user = :user").setParameter("user", (Object)serializedUser).executeUpdate();
                    return null;
                });
            }
            catch (XWikiException e) {
                throw new NotificationException(String.format("Failed to delete the notification preferences for user [%s]", user), (Throwable)e);
            }
            return null;
        });
    }

    public void deleteFilterPreference(WikiReference wikiReference, String filterPreferenceId) throws NotificationException {
        this.deleteFilterPreferences(wikiReference, Set.of(Long.valueOf(this.getInternalIdFromId(filterPreferenceId))));
        this.observation.notify((Event)new NotificationFilterPreferenceDeletedEvent(), (Object)wikiReference, (Object)filterPreferenceId);
    }

    private long getInternalIdFromId(String filterPreferenceId) throws NotificationException {
        if (Strings.CS.startsWith((CharSequence)filterPreferenceId, (CharSequence)"NFP_")) {
            return Long.parseLong(filterPreferenceId.substring("NFP_".length()));
        }
        throw new NotificationException(String.format("Cannot guess internal id of preference with id [%s].", filterPreferenceId));
    }

    public void deleteFilterPreference(WikiReference wikiReference) throws NotificationException {
        try {
            for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                this.configureContextWrapper(new WikiReference(wikiId), () -> {
                    XWikiContext context = (XWikiContext)this.contextProvider.get();
                    XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
                    try {
                        hibernateStore.executeWrite(context, session -> {
                            session.createQuery("delete from DefaultNotificationFilterPreference where page like :wikiPrefix or pageOnly like :wikiPrefix or user like :wikiPrefix or wiki = :wikiId").setParameter("wikiPrefix", (Object)(wikiReference.getName() + ":%")).setParameter("wikiId", (Object)wikiReference.getName()).executeUpdate();
                            return null;
                        });
                    }
                    catch (XWikiException e) {
                        throw new NotificationException(String.format("Failed to delete the notification preferences for wiki [%s]", wikiReference.getName()), (Throwable)e);
                    }
                    return null;
                });
            }
        }
        catch (WikiManagerException e) {
            throw new NotificationException(String.format("Error when trying to get the list of wiki ids preventing to delete filter preferences for wiki [%s]", wikiReference.getName()), (Throwable)e);
        }
    }

    private void deleteFilterPreferences(WikiReference wikiReference, Set<Long> internalFilterPreferenceIds) throws NotificationException {
        this.configureContextWrapper(wikiReference, () -> {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
            try {
                hibernateStore.executeWrite(context, session -> session.createQuery("delete from DefaultNotificationFilterPreference where internalId in (:id)").setParameter(ID, (Object)internalFilterPreferenceIds).executeUpdate());
            }
            catch (XWikiException e) {
                throw new NotificationException(String.format("Failed to delete the notification preferences [%s]", internalFilterPreferenceIds), (Throwable)e);
            }
            return null;
        });
    }

    public void saveFilterPreferences(DocumentReference user, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.saveFilterPreferences((EntityReference)user, filterPreferences);
    }

    public void saveFilterPreferences(WikiReference wikiReference, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        this.saveFilterPreferences((EntityReference)wikiReference, filterPreferences);
    }

    private void saveFilterPreferences(EntityReference entityReference, Collection<NotificationFilterPreference> filterPreferences) throws NotificationException {
        if (entityReference != null) {
            WikiReference wikiReference = (WikiReference)entityReference.extractReference(EntityType.WIKI);
            this.configureContextWrapper(wikiReference, () -> {
                String serializedEntity = (String)this.entityReferenceSerializer.serialize(entityReference, new Object[0]);
                XWikiContext context = (XWikiContext)this.contextProvider.get();
                XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
                try {
                    ArrayList preferencesToSend = new ArrayList(filterPreferences.size());
                    hibernateStore.executeWrite(context, session -> {
                        for (NotificationFilterPreference preference : filterPreferences) {
                            DefaultNotificationFilterPreference copy = new DefaultNotificationFilterPreference(preference);
                            copy.setOwner(serializedEntity);
                            session.saveOrUpdate((Object)copy);
                            preferencesToSend.add(copy);
                        }
                        return null;
                    });
                    for (DefaultNotificationFilterPreference filterPreference : preferencesToSend) {
                        this.observation.notify((Event)new NotificationFilterPreferenceAddOrUpdatedEvent(), (Object)filterPreference, (Object)entityReference);
                    }
                }
                catch (Exception e) {
                    throw new NotificationException("Failed to save the notification filter preferences.", (Throwable)e);
                }
                return null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E extends Throwable> T configureContextWrapper(WikiReference wikiReference, SupplierErr<T, E> supplier) throws E {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        WikiReference currentWiki = context.getWikiReference();
        context.setWikiReference(wikiReference);
        try {
            T t = supplier.get();
            return t;
        }
        finally {
            context.setWikiReference(currentWiki);
        }
    }

    @FunctionalInterface
    private static interface SupplierErr<T, E extends Throwable> {
        public T get() throws E;
    }
}

