/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.store.XWikiHibernateStore;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.namespace.Namespace;
import org.xwiki.component.namespace.NamespaceContextExecutor;
import org.xwiki.model.namespace.WikiNamespace;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.notifications.filters.internal.CachedFilterPreferencesModelBridge;
import org.xwiki.notifications.filters.internal.FilterPreferencesModelBridge;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Named(value="NotificationsFiltersPreferences-DocumentMovedListener")
@Singleton
public class DocumentMovedListener
extends AbstractLocalEventListener {
    public static final String NAME = "NotificationsFiltersPreferences-DocumentMovedListener";
    private static final String NEW_PAGE = "newPage";
    private static final String OLD_PAGE = "oldPage";
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    private Logger logger;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private NamespaceContextExecutor namespaceContextExecutor;
    @Inject
    @Named(value="cached")
    private FilterPreferencesModelBridge cachedFilterPreferencesModelBridge;

    public DocumentMovedListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processLocalEvent(Event event, Object source, Object data) {
        DocumentRenamedEvent renamedEvent = (DocumentRenamedEvent)event;
        DocumentReference sourceLocation = (DocumentReference)renamedEvent.getSourceReference();
        DocumentReference targetLocation = (DocumentReference)renamedEvent.getTargetReference();
        try {
            for (String wikiId : this.wikiDescriptorManager.getAllIds()) {
                this.namespaceContextExecutor.execute((Namespace)new WikiNamespace(wikiId), () -> {
                    this.updatePreferences(sourceLocation, targetLocation);
                    return null;
                });
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to update the notification filter preference when [{}] has been moved to [{}].", new Object[]{renamedEvent.getSourceReference(), renamedEvent.getTargetReference(), e});
        }
        finally {
            ((CachedFilterPreferencesModelBridge)this.cachedFilterPreferencesModelBridge).clearCache();
        }
    }

    private void updatePreferences(DocumentReference sourceLocation, DocumentReference targetLocation) throws XWikiException {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        XWikiHibernateStore hibernateStore = context.getWiki().getHibernateStore();
        hibernateStore.executeWrite(context, session -> {
            if ("WebHome".equals(sourceLocation.getName())) {
                session.createQuery("update DefaultNotificationFilterPreference p set p.page = :newPage where p.page = :oldPage").setParameter(NEW_PAGE, this.serializer.serialize((EntityReference)targetLocation.getLastSpaceReference(), new Object[0])).setParameter(OLD_PAGE, this.serializer.serialize((EntityReference)sourceLocation.getLastSpaceReference(), new Object[0])).executeUpdate();
            }
            session.createQuery("update DefaultNotificationFilterPreference p set p.pageOnly = :newPage where p.pageOnly = :oldPage").setParameter(NEW_PAGE, this.serializer.serialize((EntityReference)targetLocation, new Object[0])).setParameter(OLD_PAGE, this.serializer.serialize((EntityReference)sourceLocation, new Object[0])).executeUpdate();
            return null;
        });
    }
}

