/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.notifications.filters.internal;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.notifications.NotificationFormat;
import org.xwiki.notifications.filters.NotificationFilterPreference;
import org.xwiki.notifications.filters.NotificationFilterType;
import org.xwiki.text.StringUtils;

public class DefaultNotificationFilterPreference
implements NotificationFilterPreference {
    private static final String LIST_SEPARATOR = ",";
    private String id;
    private long internalId;
    private String owner;
    private String filterName;
    private boolean enabled;
    private NotificationFilterType filterType;
    private Set<NotificationFormat> notificationFormats = new HashSet<NotificationFormat>();
    private Date startingDate;
    private Set<String> eventTypes = new HashSet<String>();
    private String user;
    private String pageOnly;
    private String page;
    private String wiki;

    public DefaultNotificationFilterPreference() {
    }

    public DefaultNotificationFilterPreference(NotificationFilterPreference notificationFilterPreference) {
        this(notificationFilterPreference, true);
    }

    public DefaultNotificationFilterPreference(NotificationFilterPreference notificationFilterPreference, boolean keepId) {
        if (keepId && notificationFilterPreference instanceof DefaultNotificationFilterPreference) {
            this.internalId = ((DefaultNotificationFilterPreference)notificationFilterPreference).internalId;
            this.owner = ((DefaultNotificationFilterPreference)notificationFilterPreference).owner;
        }
        this.id = notificationFilterPreference.getId();
        this.filterName = notificationFilterPreference.getFilterName();
        this.enabled = notificationFilterPreference.isEnabled();
        this.filterType = notificationFilterPreference.getFilterType();
        this.notificationFormats = notificationFilterPreference.getNotificationFormats();
        this.startingDate = notificationFilterPreference.getStartingDate();
        this.eventTypes = new HashSet<String>(notificationFilterPreference.getEventTypes());
        this.user = notificationFilterPreference.getUser();
        this.pageOnly = notificationFilterPreference.getPageOnly();
        this.page = notificationFilterPreference.getPage();
        this.wiki = notificationFilterPreference.getWiki();
        this.setNotificationFormats(notificationFilterPreference.getNotificationFormats());
    }

    public void setId(String id) {
        this.id = id;
    }

    public long getInternalId() {
        return this.internalId;
    }

    public void setInternalId(long internalId) {
        this.internalId = internalId;
        this.id = String.format("%s%d", "NFP_", internalId);
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setFilterName(String filterName) {
        this.filterName = filterName;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Deprecated(since="16.5.0RC1")
    public void setActive(boolean active) {
    }

    public void setFilterType(NotificationFilterType filterType) {
        this.filterType = filterType;
    }

    public void setNotificationFormats(Set<NotificationFormat> filterFormats) {
        this.notificationFormats = filterFormats;
    }

    public void setStartingDate(Date startingDate) {
        this.startingDate = startingDate;
    }

    public void setEventTypes(Set<String> eventTypes) {
        this.eventTypes = eventTypes;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPageOnly(String pageOnly) {
        this.pageOnly = pageOnly;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public String getId() {
        return this.id;
    }

    public String getFilterName() {
        return this.filterName;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public NotificationFilterType getFilterType() {
        return this.filterType;
    }

    public Set<NotificationFormat> getNotificationFormats() {
        return this.notificationFormats;
    }

    public Date getStartingDate() {
        return this.startingDate;
    }

    public Set<String> getEventTypes() {
        return this.eventTypes;
    }

    public String getUser() {
        return this.user;
    }

    public String getPageOnly() {
        return this.pageOnly;
    }

    public String getPage() {
        return this.page;
    }

    public String getWiki() {
        return this.wiki;
    }

    public boolean isAlertEnabled() {
        return this.notificationFormats.contains(NotificationFormat.ALERT);
    }

    public void setAlertEnabled(boolean alertEnabled) {
        if (alertEnabled) {
            this.notificationFormats.add(NotificationFormat.ALERT);
        } else {
            this.notificationFormats.remove(NotificationFormat.ALERT);
        }
    }

    public boolean isEmailEnabled() {
        return this.notificationFormats.contains(NotificationFormat.EMAIL);
    }

    public void setEmailEnabled(boolean emailEnabled) {
        if (emailEnabled) {
            this.notificationFormats.add(NotificationFormat.EMAIL);
        } else {
            this.notificationFormats.remove(NotificationFormat.EMAIL);
        }
    }

    public String getAllEventTypes() {
        if (this.eventTypes.isEmpty()) {
            return "";
        }
        return LIST_SEPARATOR + StringUtils.join(this.eventTypes, (String)LIST_SEPARATOR) + LIST_SEPARATOR;
    }

    public void setAllEventTypes(String eventTypes) {
        this.eventTypes.clear();
        if (eventTypes != null) {
            String[] types = eventTypes.split(LIST_SEPARATOR);
            for (int i = 0; i < types.length; ++i) {
                if (!StringUtils.isNotBlank((CharSequence)types[i])) continue;
                this.eventTypes.add(types[i]);
            }
        }
    }

    public String toString() {
        return "DefaultNotificationFilterPreference{id='" + this.id + "', internalId=" + this.internalId + ", owner='" + this.owner + "', filterName='" + this.filterName + "', enabled=" + this.enabled + ", filterType=" + String.valueOf(this.filterType) + ", notificationFormats=" + String.valueOf(this.notificationFormats) + ", startingDate=" + String.valueOf(this.startingDate) + ", eventTypes=" + String.valueOf(this.eventTypes) + ", user='" + this.user + "', pageOnly='" + this.pageOnly + "', page='" + this.page + "', wiki='" + this.wiki + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNotificationFilterPreference other = (DefaultNotificationFilterPreference)o;
        EqualsBuilder equalsBuilder = new EqualsBuilder();
        equalsBuilder.append(this.internalId, other.internalId).append(this.enabled, other.enabled).append((Object)this.id, (Object)other.id).append((Object)this.owner, (Object)other.owner).append((Object)this.filterName, (Object)other.filterName).append((Object)this.filterType, (Object)other.filterType).append(this.notificationFormats, other.notificationFormats).append((Object)this.startingDate, (Object)other.startingDate).append(this.eventTypes, other.eventTypes).append((Object)this.user, (Object)other.user).append((Object)this.pageOnly, (Object)other.pageOnly).append((Object)this.page, (Object)other.page).append((Object)this.wiki, (Object)other.wiki);
        return equalsBuilder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        hashCodeBuilder.append(this.internalId).append(this.enabled).append((Object)this.id).append((Object)this.owner).append((Object)this.filterName).append((Object)this.filterType).append(this.notificationFormats).append((Object)this.startingDate).append(this.eventTypes).append((Object)this.user).append((Object)this.pageOnly).append((Object)this.page).append((Object)this.wiki);
        return hashCodeBuilder.toHashCode();
    }
}

