/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.internal;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.model.validation.AbstractEntityNameValidation;
import org.xwiki.model.validation.internal.ReplaceCharacterEntityNameValidationConfiguration;

@Component
@Singleton
@Named(value="ReplaceCharacterEntityNameValidation")
public class ReplaceCharacterEntityNameValidation
extends AbstractEntityNameValidation
implements Initializable {
    protected static final String COMPONENT_NAME = "ReplaceCharacterEntityNameValidation";
    private String[] forbiddenCharacters;
    private String[] replacementCharacters;
    @Inject
    private ReplaceCharacterEntityNameValidationConfiguration replaceCharacterEntityNameValidationConfiguration;

    public void initialize() throws InitializationException {
        this.setReplacementCharacters(this.replaceCharacterEntityNameValidationConfiguration.getCharacterReplacementMap());
    }

    public void setReplacementCharacters(Map<String, String> replacementMap) {
        this.forbiddenCharacters = new String[replacementMap.size()];
        this.replacementCharacters = new String[replacementMap.size()];
        int index = 0;
        for (Map.Entry<String, String> characterCharacterEntry : replacementMap.entrySet()) {
            this.forbiddenCharacters[index] = characterCharacterEntry.getKey();
            this.replacementCharacters[index] = characterCharacterEntry.getValue() != null ? characterCharacterEntry.getValue() : "";
            ++index;
        }
    }

    public String transform(String name) {
        return StringUtils.replaceEach((String)name, (String[])this.forbiddenCharacters, (String[])this.replacementCharacters);
    }

    public boolean isValid(String name) {
        return !StringUtils.containsAny((CharSequence)name, (CharSequence[])this.forbiddenCharacters);
    }
}

