/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.validation.internal;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.model.validation.internal.ReplaceCharacterEntityNameValidationConfiguration;

@Component
@Singleton
public class DefaultReplaceCharacterEntityNameValidationConfiguration
implements ReplaceCharacterEntityNameValidationConfiguration {
    protected static final String PROPERTY_KEY_FORBIDDENCHARACTERS = "replaceCharacters.forbiddenCharacters";
    protected static final String PROPERTY_KEY_REPLACEMENTCHARACTERS = "replaceCharacters.replacementCharacters";
    @Inject
    @Named(value="entitynamevalidation")
    private ConfigurationSource configurationSource;

    private List<String> getForbiddenCharacters() {
        return (List)this.configurationSource.getProperty(PROPERTY_KEY_FORBIDDENCHARACTERS, List.class);
    }

    private List<String> getReplacementCharacters() {
        return (List)this.configurationSource.getProperty(PROPERTY_KEY_REPLACEMENTCHARACTERS, List.class);
    }

    public Map<String, String> getCharacterReplacementMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        List<String> forbiddenCharacters = this.getForbiddenCharacters();
        List<String> replacementCharacters = this.getReplacementCharacters();
        if (forbiddenCharacters != null && !forbiddenCharacters.isEmpty()) {
            int replacementCharactersLength = replacementCharacters != null ? replacementCharacters.size() : 0;
            for (int i = 0; i < forbiddenCharacters.size(); ++i) {
                if (StringUtils.isEmpty((CharSequence)forbiddenCharacters.get(i))) continue;
                String replacementCharacter = i >= replacementCharactersLength ? "" : replacementCharacters.get(i);
                result.put(forbiddenCharacters.get(i), replacementCharacter);
            }
        }
        return result;
    }
}

