/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class ObjectReference
extends EntityReference {
    public ObjectReference(EntityReference reference) {
        super(reference);
    }

    protected ObjectReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public ObjectReference(String objectName, DocumentReference documentReference) {
        super(objectName, EntityType.OBJECT, (EntityReference)documentReference);
    }

    public ObjectReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    @Deprecated
    public ObjectReference(String wiki, String space, String document, String objectName) {
        this(objectName, new DocumentReference(wiki, space, document));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.OBJECT) {
            throw new IllegalArgumentException("Invalid type [" + String.valueOf((Object)type) + "] for an object reference");
        }
        super.setType(EntityType.OBJECT);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof DocumentReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + String.valueOf(parent) + "] in an object reference");
        }
        super.setParent(new DocumentReference(parent));
    }

    @Override
    public ObjectReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new ObjectReference(this, oldParent, newParent);
    }

    @Override
    public ObjectReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new ObjectReference((EntityReference)this, newParent);
    }

    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.getParent();
    }
}

