/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.reference;

import java.beans.Transient;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class AttachmentReference
extends EntityReference {
    public AttachmentReference(EntityReference reference) {
        super(reference);
    }

    protected AttachmentReference(EntityReference reference, EntityReference oldReference, EntityReference newReference) {
        super(reference, oldReference, newReference);
    }

    public AttachmentReference(EntityReference reference, EntityReference parent) {
        super(reference, parent);
    }

    public AttachmentReference(String fileName, DocumentReference parent) {
        super(fileName, EntityType.ATTACHMENT, (EntityReference)parent);
    }

    @Override
    protected void setParent(EntityReference parent) {
        if (parent instanceof DocumentReference) {
            super.setParent(parent);
            return;
        }
        if (parent == null || parent.getType() != EntityType.DOCUMENT) {
            throw new IllegalArgumentException("Invalid parent reference [" + String.valueOf(parent) + "] in an attachment reference");
        }
        super.setParent(new DocumentReference(parent));
    }

    @Override
    protected void setType(EntityType type) {
        if (type != EntityType.ATTACHMENT) {
            throw new IllegalArgumentException("Invalid type [" + String.valueOf((Object)type) + "] for an attachment reference");
        }
        super.setType(EntityType.ATTACHMENT);
    }

    @Transient
    public DocumentReference getDocumentReference() {
        return (DocumentReference)this.extractReference(EntityType.DOCUMENT);
    }

    @Override
    public AttachmentReference replaceParent(EntityReference oldParent, EntityReference newParent) {
        if (newParent == oldParent) {
            return this;
        }
        return new AttachmentReference(this, oldParent, newParent);
    }

    @Override
    public AttachmentReference replaceParent(EntityReference newParent) {
        if (newParent == this.getParent()) {
            return this;
        }
        return new AttachmentReference((EntityReference)this, newParent);
    }
}

