/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference.comparator;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;

public class DocumentReferenceComparator
implements Comparator<DocumentReference> {
    private final boolean asNestedPages;

    public DocumentReferenceComparator() {
        this(false);
    }

    public DocumentReferenceComparator(boolean asNestedPages) {
        this.asNestedPages = asNestedPages;
    }

    @Override
    public int compare(DocumentReference alice, DocumentReference bob) {
        int diff = this.compareReferenceChains(this.getActualReference(alice), this.getActualReference(bob));
        if (diff == 0) {
            diff = this.compareLocales(alice, bob);
        }
        return diff;
    }

    private EntityReference getActualReference(DocumentReference documentReference) {
        if (this.asNestedPages && "WebHome".equals(documentReference.getName())) {
            return documentReference.getLastSpaceReference();
        }
        return documentReference;
    }

    private int compareReferenceChains(EntityReference alice, EntityReference bob) {
        Iterator<EntityReference> aliceIterator = this.getPath(alice).iterator();
        Iterator<EntityReference> bobIterator = this.getPath(bob).iterator();
        while (aliceIterator.hasNext() && bobIterator.hasNext()) {
            int diff = this.compareSiblingEntities(aliceIterator.next(), bobIterator.next());
            if (diff == 0) continue;
            return diff;
        }
        if (aliceIterator.hasNext()) {
            return 1;
        }
        if (bobIterator.hasNext()) {
            return -1;
        }
        return 0;
    }

    protected List<EntityReference> getPath(EntityReference entityReference) {
        return entityReference.getReversedReferenceChain();
    }

    protected int compareSiblingEntities(EntityReference alice, EntityReference bob) {
        return alice.getName().compareTo(bob.getName());
    }

    private int compareLocales(DocumentReference alice, DocumentReference bob) {
        String aliceLocale = alice.getLocale() != null ? alice.getLocale().toString() : "";
        String bobLocale = bob.getLocale() != null ? bob.getLocale().toString() : "";
        return aliceLocale.compareTo(bobLocale);
    }
}

