/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.CharEncoding;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;

@Component
@Named(value="path")
@Singleton
public class PathStringDocumentReferenceResolver
implements DocumentReferenceResolver<String> {
    @Override
    public DocumentReference resolve(String path, Object ... args) {
        try {
            File file = new File(path);
            String page = URLDecoder.decode(file.getName(), CharEncoding.UTF_8);
            File current = file;
            String segmentName = null;
            ArrayList<String> spaceNames = new ArrayList<String>();
            while (current.getParentFile() != null) {
                current = current.getParentFile();
                segmentName = URLDecoder.decode(current.getName(), CharEncoding.UTF_8);
                if (current.getParentFile() == null) continue;
                spaceNames.add(segmentName);
            }
            Collections.reverse(spaceNames);
            String wiki = segmentName;
            return new DocumentReference(wiki, spaceNames, page);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding is not present on the system!", e);
        }
    }
}

