/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import org.xwiki.component.annotation.Component;
import org.xwiki.model.internal.reference.DefaultStringEntityReferenceSerializer;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;

@Component(staticRegistration=false)
public class LocalizedStringEntityReferenceSerializer
extends DefaultStringEntityReferenceSerializer {
    public LocalizedStringEntityReferenceSerializer(SymbolScheme symbolScheme) {
        super(symbolScheme);
    }

    @Override
    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, boolean isLastReference, Object ... parameters) {
        LocalDocumentReference documentReference;
        super.serializeEntityReference(currentReference, representation, isLastReference, parameters);
        if (currentReference instanceof DocumentReference) {
            DocumentReference documentReference2 = (DocumentReference)currentReference;
            if (documentReference2.getLocale() != null) {
                representation.append('(').append(documentReference2.getLocale()).append(')');
            }
        } else if (currentReference instanceof LocalDocumentReference && (documentReference = (LocalDocumentReference)currentReference).getLocale() != null) {
            representation.append('(').append(documentReference.getLocale()).append(')');
        }
    }
}

