/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.SymbolScheme;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;

@Component
@Named(value="local/uid")
@Singleton
public class LocalUidStringEntityReferenceSerializer
implements EntityReferenceSerializer<String> {
    public static final LocalUidStringEntityReferenceSerializer INSTANCE = new LocalUidStringEntityReferenceSerializer();
    @Inject
    private SymbolScheme symbolScheme;

    @Override
    public String serialize(EntityReference reference, Object ... parameters) {
        if (reference == null) {
            return null;
        }
        StringBuilder representation = new StringBuilder();
        for (int index = (wikiReference = (references = reference.getReversedReferenceChain()).get(0)).getType() == EntityType.WIKI ? 1 : 0; index < reference.size(); ++index) {
            EntityReference wikiReference;
            List<EntityReference> references;
            this.serializeEntityReference(references.get(index), representation, wikiReference, parameters);
        }
        return representation.toString();
    }

    protected void serializeEntityReference(EntityReference currentReference, StringBuilder representation, EntityReference wikiReference, Object ... parameters) {
        String localeString;
        Locale locale;
        String name = currentReference.getName();
        if (wikiReference != null && currentReference.getType() == EntityType.OBJECT && name.startsWith(wikiReference.getName() + String.valueOf(this.symbolScheme.getSeparatorSymbols().get((Object)EntityType.SPACE).get((Object)EntityType.WIKI)))) {
            name = name.substring(wikiReference.getName().length() + 1);
        }
        representation.append(name.length()).append(':').append(name);
        if (currentReference instanceof DocumentReference && (locale = ((DocumentReference)currentReference).getLocale()) != null && !(localeString = locale.toString()).isEmpty()) {
            representation.append(localeString.length()).append(':').append(localeString);
        }
    }
}

