/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Singleton;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.LocaleUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.SymbolScheme;

@Component
@Singleton
public class DefaultSymbolScheme
implements SymbolScheme {
    private static final char CESCAPE = '\\';
    private static final char CENTITYTYPESEP = ':';
    private static final char CWIKISEP = ':';
    private static final char CPAGESEP = '/';
    private static final char CPARAMETERSEP = ';';
    private static final char CPARAMETERVALUESEP = '=';
    private static final char CSPACESEP = '.';
    private static final char CATTACHMENTSEP = '@';
    private static final char COBJECTSEP = '^';
    private static final char CPROPERTYSEP = '.';
    private static final char CCLASSPROPSEP = '^';
    private static final Map<EntityType, Map<EntityType, Character>> SEPARATORS = new EnumMap<EntityType, Map<EntityType, Character>>(EntityType.class);
    private static final Map<EntityType, String> KEYWORDS_CURRENT = new EnumMap<EntityType, String>(EntityType.class);
    private static final Map<EntityType, String> KEYWORDS_PARENT = new EnumMap<EntityType, String>(EntityType.class);
    private static final Map<String, Type> PARAMETER_TYPES = new HashMap<String, Type>();
    private Map<EntityType, ParameterConfiguration> parameterSeparators;
    private Map<EntityType, String[]> escapes;
    private Map<EntityType, String[]> replacements;

    public DefaultSymbolScheme() {
        this.initialize(false);
    }

    public DefaultSymbolScheme(boolean withParameters) {
        this.initialize(withParameters);
    }

    private void initialize(boolean withParameters) {
        EntityType type;
        this.initializeParameters(withParameters);
        this.escapes = new EnumMap<EntityType, String[]>(EntityType.class);
        this.replacements = new EnumMap<EntityType, String[]>(EntityType.class);
        String escape = Character.toString(this.getEscapeSymbol().charValue());
        for (Map.Entry<EntityType, Map<EntityType, Character>> entry : SEPARATORS.entrySet()) {
            type = entry.getKey();
            Map<EntityType, Character> separators = entry.getValue();
            ArrayList<String> charactersToEscape = new ArrayList<String>();
            ArrayList<CallSite> replacementCharacters = new ArrayList<CallSite>();
            for (Character characterToEscape : separators.values()) {
                charactersToEscape.add(characterToEscape.toString());
                replacementCharacters.add((CallSite)((Object)(escape + characterToEscape)));
            }
            ParameterConfiguration parameter = this.parameterSeparators.get((Object)type);
            if (parameter != null && parameter.separator != null) {
                charactersToEscape.add(parameter.separator.toString());
                replacementCharacters.add((CallSite)((Object)(escape + parameter.separator)));
            }
            charactersToEscape.add(escape);
            replacementCharacters.add((CallSite)((Object)(escape + escape)));
            String[] escapesArray = new String[charactersToEscape.size()];
            this.escapes.put(type, charactersToEscape.toArray(escapesArray));
            String[] replacementsArray = new String[replacementCharacters.size()];
            this.replacements.put(type, replacementCharacters.toArray(replacementsArray));
        }
        for (Map.Entry<EntityType, Object> entry : this.parameterSeparators.entrySet()) {
            type = entry.getKey();
            ParameterConfiguration configuration = (ParameterConfiguration)entry.getValue();
            if (configuration.separator == null) continue;
            Object[] escapesArray = this.escapes.get((Object)type);
            configuration.escapes = (String[])ArrayUtils.addAll((Object[])escapesArray, (Object[])new String[]{String.valueOf('=')});
            Object[] replacementsArray = this.replacements.get((Object)type);
            configuration.replacements = (String[])ArrayUtils.addAll((Object[])replacementsArray, (Object[])new String[]{escape + "="});
        }
    }

    private void initializeParameters(boolean withParameters) {
        this.parameterSeparators = new EnumMap<EntityType, ParameterConfiguration>(EntityType.class);
        this.parameterSeparators.put(EntityType.PAGE, new ParameterConfiguration(Character.valueOf(';'), "locale"));
        this.parameterSeparators.put(EntityType.PAGE_ATTACHMENT, new ParameterConfiguration(Character.valueOf(';')));
        this.parameterSeparators.put(EntityType.PAGE_OBJECT, new ParameterConfiguration(Character.valueOf(';')));
        this.parameterSeparators.put(EntityType.PAGE_OBJECT_PROPERTY, new ParameterConfiguration(Character.valueOf(';')));
        this.parameterSeparators.put(EntityType.PAGE_CLASS_PROPERTY, new ParameterConfiguration(Character.valueOf(';')));
        if (withParameters) {
            this.parameterSeparators.put(EntityType.WIKI, new ParameterConfiguration(Character.valueOf(';')));
            this.parameterSeparators.put(EntityType.SPACE, new ParameterConfiguration(Character.valueOf(';')));
            this.parameterSeparators.put(EntityType.DOCUMENT, new ParameterConfiguration(Character.valueOf(';'), "locale"));
            this.parameterSeparators.put(EntityType.ATTACHMENT, new ParameterConfiguration(Character.valueOf(';')));
            this.parameterSeparators.put(EntityType.OBJECT, new ParameterConfiguration(Character.valueOf(';')));
            this.parameterSeparators.put(EntityType.OBJECT_PROPERTY, new ParameterConfiguration(Character.valueOf(';')));
            this.parameterSeparators.put(EntityType.CLASS_PROPERTY, new ParameterConfiguration(Character.valueOf(';')));
        }
    }

    @Override
    public Character getEscapeSymbol() {
        return Character.valueOf('\\');
    }

    @Override
    public Character getEntityTypeSeparator() {
        return Character.valueOf(':');
    }

    @Override
    public Map<EntityType, Map<EntityType, Character>> getSeparatorSymbols() {
        return SEPARATORS;
    }

    @Override
    public String[] getSymbolsRequiringEscapes(EntityType type) {
        return this.escapes.get((Object)type);
    }

    @Override
    public String[] getReplacementSymbols(EntityType type) {
        return this.replacements.get((Object)type);
    }

    @Override
    public Character getParameterSeparator(EntityType type) {
        ParameterConfiguration configuration = this.parameterSeparators.get((Object)type);
        return configuration != null ? configuration.separator : null;
    }

    @Override
    public String getDefaultParameter(EntityType type) {
        ParameterConfiguration configuration = this.parameterSeparators.get((Object)type);
        return configuration != null ? configuration.defaultParameter : null;
    }

    @Override
    public String[] getParameterSymbolsRequiringEscapes(EntityType type) {
        ParameterConfiguration configuration = this.parameterSeparators.get((Object)type);
        return configuration != null ? configuration.escapes : null;
    }

    @Override
    public String[] getParameterReplacementSymbols(EntityType type) {
        ParameterConfiguration configuration = this.parameterSeparators.get((Object)type);
        return configuration != null ? configuration.replacements : null;
    }

    @Override
    public Serializable resolveParameter(String parameter, String value) {
        Type type = PARAMETER_TYPES.get(parameter);
        if (type == Locale.class) {
            return LocaleUtils.toLocale((String)value);
        }
        return value;
    }

    @Override
    public String getCurrentReferenceKeyword(EntityType type) {
        return KEYWORDS_CURRENT.get((Object)type);
    }

    @Override
    public String getParentReferenceKeyword(EntityType type) {
        return KEYWORDS_PARENT.get((Object)type);
    }

    static {
        SEPARATORS.put(EntityType.WIKI, Collections.emptyMap());
        EnumMap<EntityType, Character> pageSeparators = new EnumMap<EntityType, Character>(EntityType.class);
        pageSeparators.put(EntityType.WIKI, Character.valueOf(':'));
        pageSeparators.put(EntityType.PAGE, Character.valueOf('/'));
        SEPARATORS.put(EntityType.PAGE, pageSeparators);
        KEYWORDS_CURRENT.put(EntityType.PAGE, ".");
        KEYWORDS_PARENT.put(EntityType.PAGE, "..");
        SEPARATORS.put(EntityType.PAGE_ATTACHMENT, Collections.singletonMap(EntityType.PAGE, Character.valueOf('/')));
        SEPARATORS.put(EntityType.PAGE_OBJECT, Collections.singletonMap(EntityType.PAGE, Character.valueOf('/')));
        SEPARATORS.put(EntityType.PAGE_OBJECT_PROPERTY, Collections.singletonMap(EntityType.PAGE_OBJECT, Character.valueOf('/')));
        SEPARATORS.put(EntityType.PAGE_CLASS_PROPERTY, Collections.singletonMap(EntityType.PAGE, Character.valueOf('/')));
        EnumMap<EntityType, Character> spaceSeparators = new EnumMap<EntityType, Character>(EntityType.class);
        spaceSeparators.put(EntityType.WIKI, Character.valueOf(':'));
        spaceSeparators.put(EntityType.SPACE, Character.valueOf('.'));
        SEPARATORS.put(EntityType.SPACE, spaceSeparators);
        SEPARATORS.put(EntityType.DOCUMENT, Collections.singletonMap(EntityType.SPACE, Character.valueOf('.')));
        SEPARATORS.put(EntityType.ATTACHMENT, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('@')));
        SEPARATORS.put(EntityType.OBJECT, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('^')));
        SEPARATORS.put(EntityType.OBJECT_PROPERTY, Collections.singletonMap(EntityType.OBJECT, Character.valueOf('.')));
        SEPARATORS.put(EntityType.CLASS_PROPERTY, Collections.singletonMap(EntityType.DOCUMENT, Character.valueOf('^')));
        PARAMETER_TYPES.put("locale", (Type)((Object)Locale.class));
    }

    private static class ParameterConfiguration {
        private Character separator;
        private String defaultParameter;
        private String[] escapes;
        private String[] replacements;

        ParameterConfiguration(Character separator, String defaultParameter) {
            this.separator = separator;
            this.defaultParameter = defaultParameter;
        }

        ParameterConfiguration(Character separator) {
            this.separator = separator;
        }
    }
}

