/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.model.internal.reference;

import java.util.List;
import org.xwiki.model.EntityType;
import org.xwiki.model.internal.reference.AbstractEntityReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceResolver;
import org.xwiki.model.reference.InvalidEntityReferenceException;

public abstract class AbstractReferenceEntityReferenceResolver
extends AbstractEntityReferenceResolver
implements EntityReferenceResolver<EntityReference> {
    @Override
    public EntityReference resolve(EntityReference referenceToResolve, EntityType type, Object ... parameters) {
        EntityReference normalizedReference = referenceToResolve;
        if (normalizedReference == null) {
            normalizedReference = this.resolveDefaultReference(type, parameters);
        } else if (normalizedReference.getType() != type) {
            if (!type.isAllowedAncestor(normalizedReference.getType()) && !normalizedReference.getType().isAllowedAncestor(type)) {
                normalizedReference = this.normalizeReference(normalizedReference, parameters);
                normalizedReference = this.toCompatibleEntityReference(normalizedReference, type);
            }
            if (type != normalizedReference.getType() && type.isAllowedAncestor(normalizedReference.getType())) {
                normalizedReference = this.resolveDefaultReference(type, parameters).appendParent(normalizedReference);
            }
        }
        try {
            normalizedReference = this.normalizeReference(normalizedReference, parameters);
        }
        catch (InvalidEntityReferenceException e) {
            throw new InvalidEntityReferenceException("Invalid reference [" + String.valueOf(referenceToResolve) + "]");
        }
        if (type != normalizedReference.getType()) {
            normalizedReference = normalizedReference.extractReference(type);
        }
        return normalizedReference;
    }

    private EntityReference normalizeReference(EntityReference referenceToResolve, Object[] parameters) {
        EntityReference normalizedReference;
        EntityReference reference = normalizedReference = referenceToResolve;
        while (reference != null) {
            EntityReference newReference;
            List<EntityType> types = reference.getType().getAllowedParents();
            if (reference.getParent() != null && this.isParentTypeAndAllowedTypeNotMatching(types, reference.getParentType())) {
                newReference = this.resolveDefaultReference(types.get(0), parameters).appendParent(reference.getParent());
                normalizedReference = normalizedReference.replaceParent(reference.getParent(), newReference);
                reference = newReference;
                continue;
            }
            if (reference.getParent() == null && reference.getParentType() != null) {
                newReference = this.resolveDefaultReference(reference.getParentType(), parameters);
                normalizedReference = normalizedReference.appendParent(newReference);
                reference = newReference;
                continue;
            }
            if (reference.getParent() != null && types.isEmpty()) {
                throw new InvalidEntityReferenceException();
            }
            reference = reference.getParent();
        }
        return normalizedReference;
    }

    private boolean isParentTypeAndAllowedTypeNotMatching(List<EntityType> allowedTypes, EntityType parentType) {
        return !allowedTypes.isEmpty() && parentType != null && !allowedTypes.contains((Object)parentType);
    }
}

