/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.eventstream.Event;
import org.xwiki.mentions.events.MentionEventParams;
import org.xwiki.mentions.internal.MentionView;
import org.xwiki.mentions.internal.MentionsNotificationsObjectMapper;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.notifications.CompositeEvent;
import org.xwiki.notifications.NotificationException;
import org.xwiki.notifications.notifiers.NotificationDisplayer;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.template.TemplateManager;

@Component
@Singleton
@Named(value="mentions")
public class MentionsNotificationDisplayer
implements NotificationDisplayer {
    private static final String EVENT_BINDING_NAME = "compositeEvent";
    private static final String EVENT_PARAMS_BINDING_NAME = "compositeEventParams";
    private static final String DEFAULT_ACTION = "view";
    @Inject
    private TemplateManager templateManager;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private DocumentAccessBridge documentAccess;
    @Inject
    private Provider<XWikiContext> contextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private MentionsNotificationsObjectMapper objectMapper;
    @Inject
    private Logger logger;

    public Block renderNotification(CompositeEvent compositeEvent) throws NotificationException {
        GroupBlock ret = new GroupBlock();
        String template = "mentions/mention.vm";
        ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
        scriptContext.setAttribute(EVENT_BINDING_NAME, compositeEvent, 100);
        Map<Event, MentionView> paramsMap = this.buildParamsMap(compositeEvent);
        scriptContext.setAttribute(EVENT_PARAMS_BINDING_NAME, paramsMap, 100);
        try {
            ret.addChildren(this.templateManager.execute(template).getChildren());
        }
        catch (Exception e) {
            throw new NotificationException(String.format("Failed to render a template [%s]", template), (Throwable)e);
        }
        return ret;
    }

    private Map<Event, MentionView> buildParamsMap(CompositeEvent compositeEvent) {
        HashMap<Event, MentionView> ret = new HashMap<Event, MentionView>();
        compositeEvent.getEvents().forEach(event -> this.deserializeParam((Event)event).flatMap(this::convert).ifPresent(it -> ret.put((Event)event, (MentionView)it)));
        return ret;
    }

    private String getExternalURL(XWikiDocument document, String anchor) {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        URL url = context.getURLFactory().createExternalURL(document.getSpace(), document.getName(), DEFAULT_ACTION, null, anchor, context);
        return url.toString();
    }

    private Optional<MentionView> convert(MentionEventParams mentionEventParams) {
        DocumentReference userReference = this.documentReferenceResolver.resolve((Object)mentionEventParams.getUserReference(), new Object[0]);
        DocumentReference documentReference = this.documentReferenceResolver.resolve((Object)mentionEventParams.getDocumentReference(), new Object[0]);
        try {
            XWikiContext context = (XWikiContext)this.contextProvider.get();
            XWikiDocument userDocumentInstance = (XWikiDocument)this.documentAccess.getDocumentInstance(userReference);
            XWikiDocument document = (XWikiDocument)this.documentAccess.getDocumentInstance(documentReference);
            String authorURL = userDocumentInstance.getExternalURL(DEFAULT_ACTION, context);
            String documentURL = this.getExternalURL(document, mentionEventParams.getAnchor());
            MentionView mentionView = new MentionView().setAuthorURL(authorURL).setDocumentURL(documentURL).setDocument(document).setLocation(mentionEventParams.getLocation().name()).setQuote(mentionEventParams.getQuote());
            return Optional.of(mentionView);
        }
        catch (Exception e) {
            this.logger.warn("Error during the conversion of [{}]. Cause [{}].", (Object)userReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Optional.empty();
        }
    }

    private Optional<MentionEventParams> deserializeParam(Event event) {
        Map parameters = event.getCustom();
        if (parameters.containsKey("mentions")) {
            return this.objectMapper.unserialize((String)parameters.get("mentions"));
        }
        return Optional.empty();
    }

    public List<String> getSupportedEvents() {
        return Collections.singletonList("mentions.mention");
    }
}

