/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.mentions.events.MentionEventParams;
import org.xwiki.mentions.internal.MentionsNotificationsObjectMapper;

@Component
@Singleton
public class DefaultMentionsNotificationsObjectMapper
implements MentionsNotificationsObjectMapper,
Initializable {
    @Inject
    private Logger logger;
    private ObjectMapper objectMapper;

    @Override
    public Optional<MentionEventParams> unserialize(String data) {
        try {
            MentionEventParams mentionEventParams = (MentionEventParams)this.objectMapper.readValue((Reader)new StringReader(data), MentionEventParams.class);
            return Optional.of(mentionEventParams);
        }
        catch (IOException e) {
            this.logger.warn("Failed to parse [{}]. Cause [{}].", (Object)data, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return Optional.empty();
        }
    }

    @Override
    public Optional<String> serialize(MentionEventParams params) {
        Optional<String> ret;
        try {
            StringWriter w = new StringWriter();
            this.objectMapper.writeValue((Writer)w, (Object)params);
            ret = Optional.of(w.toString());
        }
        catch (IOException e) {
            this.logger.warn("Failed to serialize [{}]. Cause [{}].", (Object)params, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            ret = Optional.empty();
        }
        return ret;
    }

    public void initialize() {
        this.objectMapper = new ObjectMapper();
    }
}

