/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal.rendering;

import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.phase.Initializable;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.internal.MentionFormatterProvider;
import org.xwiki.rendering.internal.renderer.plain.PlainTextRenderer;

@Component
@Named(value="plainmentions/1.0")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class PlainTextMentionsRenderer
extends PlainTextRenderer
implements Initializable {
    @Inject
    private MentionFormatterProvider mentionFormatterProvider;

    public void onMacro(String id, Map<String, String> parameters, String contentP, boolean inline) {
        if (Objects.equals(id, "mention")) {
            String userReference = parameters.get("reference");
            String style = parameters.get("style");
            String type = parameters.get("type");
            DisplayStyle displayStyle = DisplayStyle.getOrDefault((String)style);
            String hint = StringUtils.isEmpty((CharSequence)type) ? "user" : type;
            this.getPrinter().println(this.mentionFormatterProvider.get(hint).formatMention(userReference, displayStyle));
        } else {
            super.onMacro(id, parameters, contentP, inline);
        }
    }
}

