/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal.listeners;

import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.TaskManager;
import org.xwiki.observation.AbstractEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.RemoteObservationManagerContext;

@Component
@Singleton
@Named(value="MentionsCreatedEventListener")
public class MentionsCreatedEventListener
extends AbstractEventListener {
    private static final List<DocumentCreatedEvent> EVENTS = Collections.singletonList(new DocumentCreatedEvent());
    @Inject
    private Logger logger;
    @Inject
    private TaskManager taskManager;
    @Inject
    private RemoteObservationManagerContext remoteObservationManagerContext;

    public MentionsCreatedEventListener() {
        super("MentionsCreatedEventListener", EVENTS);
    }

    public void onEvent(Event event, Object source, Object data) {
        if (!(event instanceof DocumentCreatedEvent) || this.remoteObservationManagerContext.isRemoteState()) {
            return;
        }
        this.logger.debug("Event [{}] received from [{}] with data [{}].", new Object[]{DocumentCreatedEvent.class.getName(), source, data});
        XWikiDocument doc = (XWikiDocument)source;
        this.taskManager.addTask(doc.getDocumentReference().getWikiReference().getName(), doc.getId(), doc.getVersion(), "mention");
    }
}

