/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal.analyzer;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.LargeStringProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.MentionLocation;
import org.xwiki.mentions.internal.MentionXDOMService;
import org.xwiki.mentions.internal.MentionedActorReference;
import org.xwiki.mentions.internal.analyzer.AbstractDocumentMentionsAnalyzer;
import org.xwiki.mentions.notifications.MentionNotificationParameter;
import org.xwiki.mentions.notifications.MentionNotificationParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.syntax.Syntax;

@Component(roles={CreatedDocumentMentionsAnalyzer.class})
@Singleton
public class CreatedDocumentMentionsAnalyzer
extends AbstractDocumentMentionsAnalyzer {
    @Inject
    private MentionXDOMService xdomService;

    public List<MentionNotificationParameters> analyze(XWikiDocument doc, DocumentReference documentReference, String version, String authorReference) {
        Syntax syntax = doc.getSyntax();
        ArrayList<MentionNotificationParameters> mentionNotificationParametersList = new ArrayList<MentionNotificationParameters>();
        this.handleContentOnCreate(doc.getXDOM(), (EntityReference)documentReference, version, authorReference, MentionLocation.DOCUMENT).ifPresent(mentionNotificationParametersList::add);
        mentionNotificationParametersList.addAll(this.traverseXObjectsOnCreate(doc.getXObjects(), version, authorReference, syntax));
        return mentionNotificationParametersList;
    }

    private List<MentionNotificationParameters> traverseXObjectsOnCreate(Map<DocumentReference, List<BaseObject>> xObjects, String version, String authorReference, Syntax syntax) {
        ArrayList<MentionNotificationParameters> mentionNotificationParametersList = new ArrayList<MentionNotificationParameters>();
        for (List<BaseObject> baseObjects : xObjects.values()) {
            for (BaseObject baseObject : baseObjects) {
                if (baseObject == null) continue;
                mentionNotificationParametersList.addAll(this.handleBaseObjectOnCreate(baseObject, version, authorReference, syntax));
            }
        }
        return mentionNotificationParametersList;
    }

    private Optional<MentionNotificationParameters> handleContentOnCreate(XDOM xdom, EntityReference entityReference, String version, String authorReference, MentionLocation location) {
        MentionNotificationParameters mentionNotificationParameters = new MentionNotificationParameters(authorReference, entityReference, location, version);
        List<MacroBlock> blocks = this.xdomService.listMentionMacros(xdom);
        Map<MentionedActorReference, List<String>> counts = this.xdomService.groupAnchorsByUserReference(blocks);
        this.addAllMentions(mentionNotificationParameters, counts, blocks);
        for (Map.Entry<MentionedActorReference, List<String>> entry : counts.entrySet()) {
            boolean emptyAnchorProcessed = false;
            String type = entry.getKey().getType();
            String reference = entry.getKey().getReference();
            for (String anchorId : entry.getValue()) {
                DisplayStyle displayStyle = this.findDisplayStyle(blocks, reference, anchorId);
                if (StringUtils.isEmpty((CharSequence)anchorId) && emptyAnchorProcessed) continue;
                this.addNewMention(mentionNotificationParameters, type, new MentionNotificationParameter(reference, anchorId, displayStyle));
                emptyAnchorProcessed = emptyAnchorProcessed || StringUtils.isEmpty((CharSequence)anchorId);
            }
        }
        return this.wrapResult(mentionNotificationParameters);
    }

    private List<MentionNotificationParameters> handleBaseObjectOnCreate(BaseObject baseObject, String version, String authorReference, Syntax syntax) {
        ArrayList<MentionNotificationParameters> mentionNotificationParametersList = new ArrayList<MentionNotificationParameters>();
        for (Object o : baseObject.getProperties()) {
            if (!(o instanceof LargeStringProperty)) continue;
            LargeStringProperty largeStringProperty = (LargeStringProperty)o;
            String content = largeStringProperty.getValue();
            this.xdomService.parse(content, syntax).flatMap(xdom -> this.handleContentOnCreate((XDOM)xdom, largeStringProperty.getReference(), version, authorReference, MentionLocation.TEXT_FIELD)).ifPresent(mentionNotificationParametersList::add);
        }
        return mentionNotificationParametersList;
    }
}

