/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal.analyzer;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.xwiki.mentions.DisplayStyle;
import org.xwiki.mentions.internal.MentionedActorReference;
import org.xwiki.mentions.notifications.MentionNotificationParameter;
import org.xwiki.mentions.notifications.MentionNotificationParameters;
import org.xwiki.rendering.block.MacroBlock;

public abstract class AbstractDocumentMentionsAnalyzer {
    protected void addNewMention(MentionNotificationParameters mentionNotificationParameters, String type, MentionNotificationParameter mentionedActorReference) {
        mentionNotificationParameters.addNewMention(type, mentionedActorReference);
    }

    protected void addAllMentions(MentionNotificationParameters ret, Map<MentionedActorReference, List<String>> count, List<MacroBlock> mentionsMacros) {
        for (Map.Entry<MentionedActorReference, List<String>> e : count.entrySet()) {
            MentionedActorReference mentionReference = e.getKey();
            for (String anchorId : e.getValue()) {
                String reference = mentionReference.getReference();
                DisplayStyle displayStyle = this.findDisplayStyle(mentionsMacros, reference, anchorId);
                ret.addMention(mentionReference.getType(), new MentionNotificationParameter(reference, anchorId, displayStyle));
            }
        }
    }

    protected Optional<MentionNotificationParameters> wrapResult(MentionNotificationParameters mentionNotificationParameters) {
        Optional<Object> ret = mentionNotificationParameters.getNewMentions().isEmpty() ? Optional.empty() : Optional.of(mentionNotificationParameters);
        return ret;
    }

    protected DisplayStyle findDisplayStyle(List<MacroBlock> mentionsMacros, String reference, String anchor) {
        return mentionsMacros.stream().filter(it -> Objects.equals(it.getParameter("reference"), reference) && Objects.equals(it.getParameter("anchor"), anchor)).findAny().map(it -> DisplayStyle.getOrDefault((String)it.getParameter("style"))).orElse(DisplayStyle.FULL_NAME);
    }
}

