/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.mentions.internal.QuoteService;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.MacroBlock;
import org.xwiki.rendering.block.ParagraphBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.block.match.BlockMatcher;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.text.StringUtils;

@Component
@Singleton
public class DefaultQuoteService
implements QuoteService {
    @Inject
    @Named(value="plainmentions/1.0")
    private BlockRenderer renderer;

    @Override
    public Optional<String> extract(XDOM xdom, String anchorId) {
        List blockList = xdom.getBlocks((BlockMatcher)new ExactAnchorBlockMatcher(anchorId), Block.Axes.DESCENDANT);
        Optional<Block> firstBlock = blockList.size() == 1 ? Optional.of((Block)blockList.get(0)) : Optional.empty();
        return firstBlock.map(new RenderFunction()).map(it -> StringUtils.abbreviate((String)it, (String)"...", (int)200));
    }

    private static class ExactAnchorBlockMatcher
    implements BlockMatcher {
        private final String anchorId;

        ExactAnchorBlockMatcher(String anchorId) {
            this.anchorId = anchorId;
        }

        public boolean match(Block block) {
            boolean ret = block instanceof MacroBlock ? ((MacroBlock)block).getId().equals("mention") && Objects.equals(Objects.toString(block.getParameter("anchor"), ""), this.anchorId) : false;
            return ret;
        }
    }

    private final class RenderFunction
    implements Function<Block, String> {
        private RenderFunction() {
        }

        @Override
        public String apply(Block mentionBlock) {
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            Block parent = mentionBlock.getParent();
            Object block = parent instanceof XDOM ? new ParagraphBlock(Stream.of(mentionBlock.getPreviousSibling(), mentionBlock, mentionBlock.getNextSibling()).filter(Objects::nonNull).collect(Collectors.toList())) : parent;
            DefaultQuoteService.this.renderer.render(block, (WikiPrinter)printer);
            return printer.toString();
        }
    }
}

