/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mentions.internal;

import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.DocumentRevisionProvider;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.index.IndexException;
import org.xwiki.index.TaskConsumer;
import org.xwiki.mentions.events.NewMentionsEvent;
import org.xwiki.mentions.internal.analyzer.CreatedDocumentMentionsAnalyzer;
import org.xwiki.mentions.internal.analyzer.UpdatedDocumentMentionsAnalyzer;
import org.xwiki.mentions.notifications.MentionNotificationParameters;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;
import org.xwiki.user.UserReferenceSerializer;

@Component
@Singleton
@Named(value="mention")
public class DefaultMentionsDataConsumer
implements TaskConsumer {
    @Inject
    private DocumentRevisionProvider documentRevisionProvider;
    @Inject
    private ObservationManager observationManager;
    @Inject
    private CreatedDocumentMentionsAnalyzer createdDocumentMentionsAnalyzer;
    @Inject
    private UpdatedDocumentMentionsAnalyzer updatedDocumentMentionsAnalyzer;
    @Inject
    private UserReferenceSerializer<String> userReferenceSerializer;

    public void consume(DocumentReference documentReference, String version) throws IndexException {
        try {
            XWikiDocument doc = this.documentRevisionProvider.getRevision(documentReference, version);
            if (doc != null) {
                List<MentionNotificationParameters> mentionNotificationParameters;
                String authorReference = (String)this.userReferenceSerializer.serialize(doc.getAuthors().getOriginalMetadataAuthor());
                if (doc.getPreviousVersion() == null) {
                    mentionNotificationParameters = this.createdDocumentMentionsAnalyzer.analyze(doc, documentReference, doc.getVersion(), authorReference);
                } else {
                    XWikiDocument oldDoc = this.documentRevisionProvider.getRevision(doc.getDocumentReferenceWithLocale(), doc.getPreviousVersion());
                    mentionNotificationParameters = this.updatedDocumentMentionsAnalyzer.analyze(oldDoc, doc, documentReference, doc.getVersion(), authorReference);
                }
                this.sendNotification(mentionNotificationParameters);
            }
        }
        catch (XWikiException e) {
            throw new IndexException("Failed during the mention task execution", (Throwable)e);
        }
    }

    private void sendNotification(List<MentionNotificationParameters> notificationParametersList) {
        for (MentionNotificationParameters mentionNotificationParameters : notificationParametersList) {
            Map newMentions = mentionNotificationParameters.getNewMentions();
            if (newMentions.isEmpty()) continue;
            this.observationManager.notify((Event)new NewMentionsEvent(), (Object)mentionNotificationParameters.getAuthorReference(), (Object)mentionNotificationParameters);
        }
    }
}

