/*
 * Decompiled with CFR 0.152.
 */
package com.xpn.xwiki.plugin.mailsender;

import com.xpn.xwiki.api.Attachment;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Mail {
    private String from;
    private String to;
    private String cc;
    private String bcc;
    private String subject;
    private String textPart;
    private String htmlPart;
    private List<Attachment> attachments;
    private Map<String, String> headers = new TreeMap<String, String>();

    public Mail() {
    }

    public Mail(String from, String to, String cc, String bcc, String subject, String textPart, String htmlPart) {
        this();
        this.from = from;
        this.to = to;
        this.cc = cc;
        this.bcc = bcc;
        this.subject = subject;
        this.textPart = textPart;
        this.htmlPart = htmlPart;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(List<Attachment> attachments) {
        this.attachments = attachments;
    }

    public String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to;
    }

    public String getCc() {
        return this.cc;
    }

    public void setCc(String cc) {
        this.cc = cc;
    }

    public String getBcc() {
        return this.bcc;
    }

    public void setBcc(String bcc) {
        this.bcc = bcc;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getTextPart() {
        return this.textPart;
    }

    public void setTextPart(String message) {
        this.textPart = message;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        if (this.getFrom() != null) {
            buffer.append("From [" + this.getFrom() + "]");
        }
        if (this.getTo() != null) {
            buffer.append(", To [" + this.getTo() + "]");
        }
        if (this.getCc() != null) {
            buffer.append(", Cc [" + this.getCc() + "]");
        }
        if (this.getBcc() != null) {
            buffer.append(", Bcc [" + this.getBcc() + "]");
        }
        if (this.getSubject() != null) {
            buffer.append(", Subject [" + this.getSubject() + "]");
        }
        if (this.getTextPart() != null) {
            buffer.append(", Text [" + this.getTextPart() + "]");
        }
        if (this.getHtmlPart() != null) {
            buffer.append(", HTML [" + this.getHtmlPart() + "]");
        }
        if (!this.getHeaders().isEmpty()) {
            buffer.append(", Headers [" + this.toStringHeaders() + "]");
        }
        return buffer.toString();
    }

    private String toStringHeaders() {
        StringBuilder buffer = new StringBuilder();
        for (Map.Entry<String, String> header : this.getHeaders().entrySet()) {
            buffer.append('[');
            buffer.append(header.getKey());
            buffer.append(']');
            buffer.append(' ');
            buffer.append('=');
            buffer.append(' ');
            buffer.append('[');
            buffer.append(header.getValue());
            buffer.append(']');
        }
        return buffer.toString();
    }

    public String getHtmlPart() {
        return this.htmlPart;
    }

    public void setHtmlPart(String htmlPart) {
        this.htmlPart = htmlPart;
    }

    public void setHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public String getHeader(String header) {
        return this.headers.get(header);
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }
}

