/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread;

import com.xpn.xwiki.XWikiContext;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.ExecutionContext;
import org.xwiki.context.ExecutionContextException;
import org.xwiki.context.ExecutionContextManager;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailListener;
import org.xwiki.mail.internal.thread.AbstractMailRunnable;
import org.xwiki.mail.internal.thread.MailQueueManager;
import org.xwiki.mail.internal.thread.SendMailQueueItem;

@Component
@Named(value="send")
@Singleton
public class SendMailRunnable
extends AbstractMailRunnable {
    @Inject
    private MailQueueManager<SendMailQueueItem> sendMailQueueManager;
    @Inject
    @Named(value="filesystem")
    private MailContentStore mailContentStore;
    @Inject
    private ExecutionContextManager executionContextManager;
    @Inject
    private Provider<XWikiContext> contextProvider;
    private Transport currentTransport;
    private Session currentSession;
    private int count;

    @Override
    public void run() {
        try {
            this.prepareContext();
            this.runInternal();
        }
        catch (ExecutionContextException e) {
            this.logger.error("Failed to initialize the send mail thread's execution context", (Throwable)e);
        }
        finally {
            this.closeTransport();
        }
    }

    private void prepareContext() throws ExecutionContextException {
        ExecutionContext ec = new ExecutionContext();
        this.executionContextManager.initialize(ec);
    }

    private void prepareContextForQueueItem(SendMailQueueItem mailItem) {
        XWikiContext xcontext = (XWikiContext)this.contextProvider.get();
        xcontext.setWikiId(mailItem.getWikiId());
    }

    private void runInternal() {
        do {
            try {
                if (this.sendMailQueueManager.hasMessage()) {
                    SendMailQueueItem mailItem = this.sendMailQueueManager.peekMessage();
                    try {
                        this.sendMail(mailItem);
                    }
                    finally {
                        this.sendMailQueueManager.removeMessageFromQueue(mailItem);
                    }
                    this.waitSendWaitTime();
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.logger.debug("Mail Sender Thread was forcefully stopped", (Throwable)e);
                break;
            }
            catch (Exception e) {
                this.logger.error("Unexpected error in the Mail Sender Thread", (Throwable)e);
            }
        } while (!this.shouldStop);
    }

    protected void sendMail(SendMailQueueItem item) {
        block9: {
            ExtendedMimeMessage message;
            this.prepareContextForQueueItem(item);
            MailListener listener = item.getListener();
            try {
                message = this.mailContentStore.load(item.getSession(), item.getBatchId(), item.getUniqueMessageId());
            }
            catch (Exception e) {
                if (listener != null) {
                    listener.onSendMessageFatalError(item.getUniqueMessageId(), e, Collections.emptyMap());
                }
                return;
            }
            try {
                if (item.getSession() != this.currentSession || this.count % 100 == 0) {
                    this.closeTransport();
                    this.currentSession = item.getSession();
                    this.currentTransport = this.currentSession.getTransport("smtp");
                    this.currentTransport.connect();
                } else if (!this.currentTransport.isConnected()) {
                    this.currentTransport.connect();
                }
                this.currentTransport.sendMessage((Message)message, message.getAllRecipients());
                ++this.count;
                if (listener != null) {
                    listener.onSendMessageSuccess(message, Collections.emptyMap());
                }
            }
            catch (Exception e) {
                if (listener == null) break block9;
                listener.onSendMessageError(message, e, Collections.emptyMap());
            }
        }
    }

    private void waitSendWaitTime() throws InterruptedException {
        long sendWaitTime = this.configuration.getSendWaitTime();
        Thread.sleep(sendWaitTime);
    }

    private void closeTransport() {
        if (this.currentTransport != null) {
            try {
                this.currentTransport.close();
            }
            catch (MessagingException e) {
                this.logger.warn("Failed to close JavaMail Transport connection. Reason [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }
}

