/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.thread;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import org.xwiki.component.phase.Initializable;
import org.xwiki.mail.internal.thread.MailQueueItem;
import org.xwiki.mail.internal.thread.MailQueueManager;

public abstract class AbstractMailQueueManager<T extends MailQueueItem>
implements MailQueueManager<T>,
Initializable {
    protected BlockingQueue<T> mailQueue;

    private BlockingQueue<T> getMailQueue() {
        return this.mailQueue;
    }

    @Override
    public void addToQueue(T mailQueueItem) {
        this.getMailQueue().add(mailQueueItem);
    }

    @Override
    public void addMessage(T mailQueueItem, long timeout, TimeUnit unit) throws InterruptedException {
        this.getMailQueue().offer(mailQueueItem, timeout, unit);
    }

    @Override
    public boolean addMessageToQueue(T mailQueueItem, long timeout, TimeUnit unit) throws InterruptedException {
        return this.getMailQueue().offer(mailQueueItem, timeout, unit);
    }

    @Override
    public boolean hasMessage() {
        return !this.getMailQueue().isEmpty();
    }

    @Override
    public T peekMessage() {
        return (T)((MailQueueItem)this.getMailQueue().peek());
    }

    @Override
    public boolean removeMessageFromQueue(T mailQueueItem) {
        return this.getMailQueue().remove(mailQueueItem);
    }
}

