/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.usersandgroups;

import java.util.Iterator;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.xwiki.context.Execution;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MimeMessageFactory;
import org.xwiki.mail.internal.factory.usersandgroups.AddressUserIterator;
import org.xwiki.mail.internal.factory.usersandgroups.UsersAndGroupsSource;
import org.xwiki.model.reference.DocumentReferenceResolver;

public class UsersAndGroupsMimeMessageIterator
implements Iterator<MimeMessage>,
Iterable<MimeMessage> {
    private MimeMessageFactory<MimeMessage> factory;
    private Iterator<Address> addressIterator;
    private Map<String, Object> parameters;

    public UsersAndGroupsMimeMessageIterator(Map<String, Object> source, MimeMessageFactory<MimeMessage> factory, Map<String, Object> parameters, DocumentReferenceResolver<String> explicitDocumentReferenceResolver, Execution execution) throws MessagingException {
        this.addressIterator = new AddressUserIterator(UsersAndGroupsSource.parse(source), explicitDocumentReferenceResolver, execution);
        this.factory = factory;
        this.parameters = parameters;
    }

    @Override
    public Iterator<MimeMessage> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.addressIterator.hasNext();
    }

    @Override
    public MimeMessage next() {
        MimeMessage message;
        Address address = this.addressIterator.next();
        try {
            Map factoryParameters = (Map)this.parameters.get("parameters");
            message = (MimeMessage)this.factory.createMessage(this.parameters.get("source"), factoryParameters);
            message.addRecipient(Message.RecipientType.TO, address);
            String type = (String)this.parameters.get("type");
            if (type != null) {
                ExtendedMimeMessage.wrap((MimeMessage)message).setType(type);
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException("Failed to create Mime Message for recipient " + String.valueOf(address), e);
        }
        return message;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove");
    }
}

