/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.usersandgroups;

import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.internal.plugin.rightsmanager.UserDataExtractor;
import com.xpn.xwiki.objects.BaseObject;
import javax.mail.Address;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.model.reference.DocumentReference;

public class AddressUserDataExtractor
implements UserDataExtractor<Address> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddressUserDataExtractor.class);

    public Address extractFromSuperadmin(DocumentReference reference) {
        return null;
    }

    public Address extractFromGuest(DocumentReference reference) {
        return null;
    }

    public Address extract(DocumentReference reference, XWikiDocument document, BaseObject userObject) {
        InternetAddress address = null;
        String email = userObject.getStringValue("email");
        if (!StringUtils.isBlank((CharSequence)email)) {
            try {
                address = InternetAddress.parse((String)email)[0];
            }
            catch (AddressException e) {
                LOGGER.warn("Found invalid email address [{}] for user [{}]. Email will not been sent to that user.", (Object)email, (Object)reference);
            }
        } else {
            LOGGER.warn("User [{}] has no email defined. Email will not been sent to that user.", (Object)reference);
        }
        return address;
    }
}

