/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal.factory.template;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.internal.velocity.VelocityEvaluator;
import com.xpn.xwiki.web.ExternalServletURLFactory;
import com.xpn.xwiki.web.XWikiURLFactory;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.mail.MessagingException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.LocaleUtils;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.mail.internal.factory.template.MailTemplateManager;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.XWikiVelocityContext;
import org.xwiki.velocity.XWikiVelocityException;

@Component
@Singleton
public class DefaultMailTemplateManager
implements MailTemplateManager {
    private static final EntityReference MAIL_CLASS = new EntityReference("Mail", EntityType.DOCUMENT, new EntityReference("XWiki", EntityType.SPACE));
    private static final String LANGUAGE_PROPERTY_NAME = "language";
    @Inject
    private DocumentAccessBridge documentBridge;
    @Inject
    private EntityReferenceSerializer<String> serializer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<EntityReference> resolver;
    @Inject
    private VelocityManager velocityManager;
    @Inject
    private VelocityEvaluator velocityEvaluator;
    @Inject
    private VelocityContextFactory velocityContextFactory;
    @Inject
    private LoggerConfiguration loggerConfiguration;
    @Inject
    private Provider<XWikiContext> xwikiContextProvider;
    @Inject
    private Logger logger;

    @Override
    public String evaluate(DocumentReference templateReference, String property, Map<String, Object> velocityVariables, Object localeValue) throws MessagingException {
        Locale locale = this.getLocale(localeValue);
        DocumentReference mailClassReference = this.resolver.resolve((Object)MAIL_CLASS, new Object[]{templateReference.getWikiReference()});
        VelocityContext velocityContext = this.createVelocityContext(velocityVariables);
        String templateFullName = (String)this.serializer.serialize((EntityReference)templateReference, new Object[0]);
        int objectNumber = this.getObjectMailNumber(templateReference, mailClassReference, locale);
        String content = this.documentBridge.getProperty(templateReference, mailClassReference, objectNumber, property).toString();
        XWikiContext xcontext = (XWikiContext)this.xwikiContextProvider.get();
        XWikiURLFactory originalURLFactory = xcontext.getURLFactory();
        Locale originalLocale = xcontext.getLocale();
        try {
            xcontext.setURLFactory((XWikiURLFactory)new ExternalServletURLFactory(xcontext));
            xcontext.setLocale(locale);
            String string = this.velocityEvaluator.evaluateVelocity(content, templateFullName, velocityContext);
            return string;
        }
        catch (XWikiException e) {
            throw new MessagingException(String.format("Failed to evaluate property [%s] for Document [%s] and locale [%s]", property, templateReference, localeValue), (Exception)((Object)e));
        }
        finally {
            xcontext.setURLFactory(originalURLFactory);
            xcontext.setLocale(originalLocale);
        }
    }

    @Override
    public String evaluate(DocumentReference templateReference, String property, Map<String, Object> data) throws MessagingException {
        return this.evaluate(templateReference, property, data, null);
    }

    private int getObjectMailNumber(DocumentReference templateReference, DocumentReference mailClassReference, Locale language) throws MessagingException {
        int number = this.documentBridge.getObjectNumber(templateReference, mailClassReference, LANGUAGE_PROPERTY_NAME, language.getLanguage());
        int mailObjectsCount = this.getMailObjectsCount(templateReference, mailClassReference);
        if (!this.getDefaultLocale().equals(language) && number == -1) {
            number = this.documentBridge.getObjectNumber(templateReference, mailClassReference, LANGUAGE_PROPERTY_NAME, this.getDefaultLocale().getLanguage());
        }
        if (mailObjectsCount == 1 && number == -1) {
            number = 0;
        } else {
            if (mailObjectsCount == 0 && number == -1) {
                throw new MessagingException(String.format("No [%s] object found in the Document [%s] for language [%s]", MAIL_CLASS.toString(), templateReference, language));
            }
            if (number == -1) {
                throw new MessagingException(String.format("No [%s] object matches the locale [%s] or the default locale [%s] in the Document [%s]", MAIL_CLASS.toString(), language, this.getDefaultLocale(), templateReference));
            }
        }
        return number;
    }

    private int getMailObjectsCount(DocumentReference templateReference, DocumentReference mailClassReference) throws MessagingException {
        int objectsCount;
        XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
        try {
            List objects = context.getWiki().getDocument(templateReference, context).getXObjects(mailClassReference);
            objectsCount = objects != null ? objects.size() : 0;
        }
        catch (XWikiException e) {
            throw new MessagingException(String.format("Failed to find number of [%s] objects in Document [%s]", mailClassReference, templateReference), (Exception)((Object)e));
        }
        return objectsCount;
    }

    private VelocityContext createVelocityContext(Map<String, Object> velocityVariables) {
        VelocityContext velocityContext;
        VelocityContext existingVelocityContext = this.velocityManager.getVelocityContext();
        if (existingVelocityContext != null) {
            velocityContext = new XWikiVelocityContext((Context)existingVelocityContext, this.loggerConfiguration.isDeprecatedLogEnabled());
        } else {
            try {
                velocityContext = this.velocityContextFactory.createContext();
            }
            catch (XWikiVelocityException e) {
                this.logger.error("Failed to create standard VelocityContext", (Throwable)e);
                velocityContext = new XWikiVelocityContext();
            }
        }
        if (velocityVariables != null) {
            for (Map.Entry<String, Object> velocityVariable : velocityVariables.entrySet()) {
                velocityContext.put(velocityVariable.getKey(), velocityVariable.getValue());
            }
        }
        return velocityContext;
    }

    private Locale getDefaultLocale() {
        XWikiContext context = (XWikiContext)this.xwikiContextProvider.get();
        return context.getWiki().getDefaultLocale(context);
    }

    private Locale getLocale(Object languageValue) {
        Locale locale = languageValue == null || languageValue instanceof Locale && Locale.ROOT.equals(languageValue) ? this.getDefaultLocale() : (languageValue instanceof Locale ? (Locale)languageValue : LocaleUtils.toLocale((String)languageValue.toString()));
        return locale;
    }
}

