/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseObject;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.mail.internal.configuration.AbstractMailConfigClassDocumentConfigurationSource;
import org.xwiki.mail.internal.configuration.AbstractSendMailConfigClassDocumentConfigurationSource;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.LocalDocumentReference;
import org.xwiki.security.internal.DocumentInitializerRightsManager;
import org.xwiki.user.GuestUserReference;
import org.xwiki.user.SuperAdminUserReference;
import org.xwiki.user.UserReference;

@Component
@Singleton
@Named(value="Mail.MailConfig")
public class MailConfigMandatoryDocumentInitializer
implements MandatoryDocumentInitializer {
    @Inject
    private Logger logger;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentInitializerRightsManager documentInitializerRightsManager;

    public EntityReference getDocumentReference() {
        return AbstractMailConfigClassDocumentConfigurationSource.MAILCONFIG_REFERENCE;
    }

    public boolean updateDocument(XWikiDocument document) {
        boolean needsUpdate = this.updateReferences(document);
        if (!document.isHidden().booleanValue()) {
            document.setHidden(Boolean.valueOf(true));
            needsUpdate = true;
        }
        if (document.getTitle().isEmpty()) {
            document.setTitle("Mail Configuration");
            needsUpdate = true;
        }
        if (this.addGeneralMailConfigClassXObject(document)) {
            needsUpdate = true;
        }
        if (this.addSendMailConfigClassXObject(document)) {
            needsUpdate = true;
        }
        if (this.removeConfigurableClass(document)) {
            needsUpdate = true;
        }
        if (this.documentInitializerRightsManager.restrictToAdmin(document)) {
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean updateReferences(XWikiDocument document) {
        boolean needsUpdate = false;
        if (document.getAuthors().getCreator() == GuestUserReference.INSTANCE) {
            document.getAuthors().setCreator((UserReference)SuperAdminUserReference.INSTANCE);
            needsUpdate = true;
        }
        if (document.getAuthors().getEffectiveMetadataAuthor() == GuestUserReference.INSTANCE) {
            document.getAuthors().setEffectiveMetadataAuthor(document.getAuthors().getCreator());
            needsUpdate = true;
        }
        if (document.getParentReference() == null) {
            LocalDocumentReference parentReference = new LocalDocumentReference("Mail", "WebHome");
            document.setParentReference((EntityReference)parentReference);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean removeConfigurableClass(XWikiDocument document) {
        boolean needsUpdate = false;
        LocalDocumentReference configurableClassReference = new LocalDocumentReference("XWiki", "ConfigurableClass");
        if (document.getXObject((EntityReference)configurableClassReference) != null) {
            document.removeXObjects((EntityReference)configurableClassReference);
            needsUpdate = true;
        }
        return needsUpdate;
    }

    private boolean addGeneralMailConfigClassXObject(XWikiDocument document) {
        return this.addXObject(document, new LocalDocumentReference("Mail", "GeneralMailConfigClass"), Map.of("obfuscateEmailAddresses", "obfuscate"));
    }

    private boolean addSendMailConfigClassXObject(XWikiDocument document) {
        return this.addXObject(document, AbstractSendMailConfigClassDocumentConfigurationSource.SENDMAILCONFIGCLASS_REFERENCE, Map.of("admin_email", "from", "smtp_server", "host", "smtp_port", "port", "smtp_server_username", "username", "smtp_server_password", "password", "javamail_extra_props", "properties"));
    }

    private boolean addXObject(XWikiDocument document, LocalDocumentReference classReference, Map<String, String> fieldMappings) {
        boolean needsUpdate = false;
        if (document.getXObject((EntityReference)classReference) == null) {
            try {
                XWikiContext xwikiContext = (XWikiContext)this.xcontextProvider.get();
                XWiki xwiki = xwikiContext.getWiki();
                BaseObject object = document.newXObject((EntityReference)classReference, xwikiContext);
                for (Map.Entry<String, String> entry : fieldMappings.entrySet()) {
                    this.setField(entry.getKey(), entry.getValue(), object, xwiki, xwikiContext);
                }
                needsUpdate = true;
            }
            catch (XWikiException e) {
                this.logger.error(String.format("Error adding a [%s] object to the document [%s]", classReference.toString(), document.getDocumentReference().toString()));
            }
        }
        return needsUpdate;
    }

    private void setField(String oldPropertyName, String newPropertyName, BaseObject object, XWiki xwiki, XWikiContext xwikiContext) throws XWikiException {
        String oldValue = xwiki.getSpacePreference(oldPropertyName, xwikiContext);
        if (!StringUtils.isEmpty((CharSequence)oldValue)) {
            object.set(newPropertyName, (Object)oldValue, xwikiContext);
        }
    }
}

