/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Session;
import org.apache.commons.io.FileUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.phase.Initializable;
import org.xwiki.environment.Environment;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailContentStore;
import org.xwiki.mail.MailStoreException;

@Component
@Named(value="filesystem")
@Singleton
public class FileSystemMailContentStore
implements MailContentStore,
Initializable {
    public static final String ROOT_DIRECTORY = "mails";
    private File rootDirectory;
    @Inject
    private Environment environment;

    public void initialize() {
        this.rootDirectory = new File(this.environment.getPermanentDirectory(), ROOT_DIRECTORY);
    }

    public void save(String batchId, ExtendedMimeMessage message) throws MailStoreException {
        List<File> temporaryFiles = this.extractTemporaryFilesFromHeaders(message);
        String uniqueMessageId = message.getUniqueMessageId();
        File messageFile = this.getMessageFile(batchId, uniqueMessageId);
        messageFile.getParentFile().mkdirs();
        try {
            if (message.ensureSaved()) {
                uniqueMessageId = message.getUniqueMessageId();
                messageFile = this.getMessageFile(batchId, uniqueMessageId);
            }
            message.writeTo((OutputStream)new FileOutputStream(messageFile));
            for (File temporaryFile : temporaryFiles) {
                FileUtils.forceDelete((File)temporaryFile);
            }
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to save message (id [%s], batch id [%s]) into file [%s]", uniqueMessageId, batchId, messageFile), (Throwable)e);
        }
    }

    public ExtendedMimeMessage load(Session session, String batchId, String uniqueMessageId) throws MailStoreException {
        File messageFile = null;
        try {
            messageFile = this.getMessageFile(batchId, uniqueMessageId);
            FileInputStream is = new FileInputStream(messageFile);
            return new ExtendedMimeMessage(session, (InputStream)is);
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to load message (id [%s], batch id [%s]) from file [%s]", uniqueMessageId, batchId, messageFile), (Throwable)e);
        }
    }

    public void delete(String batchId, String uniqueMessageId) throws MailStoreException {
        File messageFile = null;
        try {
            messageFile = this.getMessageFile(batchId, uniqueMessageId);
            if (messageFile.exists()) {
                messageFile.delete();
            }
            if (messageFile.getParentFile().exists()) {
                messageFile.getParentFile().delete();
            }
        }
        catch (Exception e) {
            throw new MailStoreException(String.format("Failed to delete message (id [%s], batch id [%s]) file [%s]", uniqueMessageId, batchId, messageFile), (Throwable)e);
        }
    }

    private List<File> extractTemporaryFilesFromHeaders(ExtendedMimeMessage message) throws MailStoreException {
        ArrayList<File> temporaryFiles = new ArrayList<File>();
        try {
            Object content = message.getContent();
            if (content instanceof Multipart) {
                Multipart multipart = (Multipart)content;
                for (int i = 0; i < multipart.getCount(); ++i) {
                    BodyPart part = multipart.getBodyPart(i);
                    String[] temporaryFileLocations = part.getHeader("X-TmpFile");
                    if (temporaryFileLocations == null || temporaryFileLocations.length <= 0) continue;
                    temporaryFiles.add(new File(temporaryFileLocations[0]));
                    part.removeHeader("X-TmpFile");
                    message.saveChanges();
                }
            }
        }
        catch (Exception e) {
            throw new MailStoreException("Failed to extract temporary file refernces from headers", (Throwable)e);
        }
        return temporaryFiles;
    }

    private File getBatchDirectory(String batchId) {
        File batchDirectory = new File(this.rootDirectory, FileSystemMailContentStore.getURLEncoded(batchId));
        return batchDirectory;
    }

    private File getMessageFile(String batchId, String uniqueMessageId) {
        return new File(this.getBatchDirectory(batchId), FileSystemMailContentStore.getURLEncoded(uniqueMessageId));
    }

    private static String getURLEncoded(String toEncode) {
        try {
            return URLEncoder.encode(toEncode, "UTF-8");
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("UTF-8 not available, this Java VM is not standards compliant!");
        }
    }
}

