/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.mail;

import java.util.Date;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.internet.InternetAddress;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.xwiki.mail.ExtendedMimeMessage;
import org.xwiki.mail.MailState;
import org.xwiki.text.XWikiToStringBuilder;

public class MailStatus {
    private String uniqueMessageId;
    private String state;
    private String batchId;
    private Date date;
    private String recipients;
    private String type;
    private String errorSummary;
    private String errorDescription;
    private String wiki;

    public MailStatus() {
    }

    public MailStatus(String batchId, ExtendedMimeMessage message, MailState state) {
        try {
            this.setMessageId(message.getUniqueMessageId());
            this.setBatchId(batchId);
            this.setType(message.getType());
            this.setRecipients(InternetAddress.toString((Address[])message.getAllRecipients()));
            this.setState(state);
            this.setDate(new Date());
        }
        catch (MessagingException e) {
            throw new RuntimeException(String.format("Unexpected exception constructing the Mail Status for state [%s]", new Object[]{state}), e);
        }
    }

    public String getMessageId() {
        return this.uniqueMessageId;
    }

    public void setMessageId(String messageId) {
        this.uniqueMessageId = messageId;
    }

    public String getState() {
        return this.state;
    }

    public void setState(MailState state) {
        this.state = state.toString();
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getBatchId() {
        return this.batchId;
    }

    public void setBatchId(String batchId) {
        this.batchId = batchId;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public String getErrorDescription() {
        return this.errorDescription;
    }

    public void setErrorSummary(String errorSummary) {
        this.errorSummary = errorSummary;
    }

    public void setErrorDescription(String errorDescription) {
        this.errorDescription = errorDescription;
    }

    public void setError(Exception exception) {
        this.errorSummary = ExceptionUtils.getRootCauseMessage((Throwable)exception);
        this.errorDescription = ExceptionUtils.getStackTrace((Throwable)exception);
    }

    public String getWiki() {
        return this.wiki;
    }

    public void setWiki(String wiki) {
        this.wiki = wiki;
    }

    public String toString() {
        XWikiToStringBuilder builder = new XWikiToStringBuilder((Object)this);
        builder.append("messageId", (Object)this.getMessageId());
        builder.append("batchId", (Object)this.getBatchId());
        builder.append("state", (Object)this.getState());
        builder.append("date", (Object)this.getDate());
        builder.append("recipients", (Object)this.getRecipients());
        if (this.getType() != null) {
            builder.append("type", (Object)this.getType());
        }
        if (this.getErrorSummary() != null) {
            builder.append("errorSummary", (Object)this.getErrorSummary());
        }
        if (this.getErrorDescription() != null) {
            builder.append("errorDescription", (Object)this.getErrorDescription());
        }
        if (this.getWiki() != null) {
            builder.append("wiki", (Object)this.getWiki());
        }
        return builder.toString();
    }
}

