/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.wiki.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.Locale;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.localization.wiki.internal.AbstractDocumentTranslationBundle;
import org.xwiki.localization.wiki.internal.DocumentTranslationBundleFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.event.Event;
import org.xwiki.security.authorization.AccessDeniedException;

public class ComponentDocumentTranslationBundle
extends AbstractDocumentTranslationBundle {
    private DocumentTranslationBundleFactory factory;
    private ComponentDescriptor<TranslationBundle> descriptor;

    public ComponentDocumentTranslationBundle(String idPrefix, DocumentReference documentReference, ComponentManager componentManager, TranslationMessageParser translationMessageParser, ComponentDescriptor<TranslationBundle> descriptor, DocumentTranslationBundleFactory factory) throws ComponentLookupException {
        super(idPrefix, documentReference, componentManager, translationMessageParser);
        this.factory = factory;
        this.descriptor = descriptor;
    }

    @Override
    protected XWikiDocument getDocumentLocaleBundle(Locale locale) throws Exception {
        XWikiContext context;
        XWiki xwiki;
        XWikiDocument defaultLocaleDocument;
        XWikiDocument document = super.getDocumentLocaleBundle(locale);
        if (document != null && !document.isNew() && (defaultLocaleDocument = (xwiki = (context = (XWikiContext)this.contextProvider.get()).getWiki()).getDocument(this.documentReference, context)) != document) {
            try {
                this.factory.checkRegistrationAuthorizationForDocumentLocaleBundle(document, defaultLocaleDocument);
            }
            catch (AccessDeniedException e) {
                this.logger.warn("Failed to load and register the translation for locale [{}] from document [{}]. Falling back to default locale.", (Object)locale, (Object)document.getDocumentReference());
                return defaultLocaleDocument;
            }
        }
        return document;
    }

    @Override
    public void onEvent(Event event, Object source, Object data) {
        super.onEvent(event, source, data);
        if (event instanceof WikiDeletedEvent) {
            this.componentManager.unregisterComponent(this.descriptor);
        }
    }
}

