/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.wiki.internal;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.XWikiDocument;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Provider;
import org.slf4j.LoggerFactory;
import org.xwiki.bridge.event.DocumentCreatedEvent;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.bridge.event.DocumentUpdatedEvent;
import org.xwiki.bridge.event.WikiDeletedEvent;
import org.xwiki.cache.DisposableCacheValue;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Disposable;
import org.xwiki.localization.Translation;
import org.xwiki.localization.TranslationBundle;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.internal.AbstractCachedTranslationBundle;
import org.xwiki.localization.internal.DefaultLocalizedTranslationBundle;
import org.xwiki.localization.internal.DefaultTranslation;
import org.xwiki.localization.internal.LocalizedTranslationBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.localization.message.TranslationMessageParser;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.ObservationManager;
import org.xwiki.observation.event.Event;

public abstract class AbstractDocumentTranslationBundle
extends AbstractCachedTranslationBundle
implements DisposableCacheValue,
Disposable,
EventListener {
    public static final int DEFAULTPRIORITY_WIKI = 900;
    protected ComponentManager componentManager;
    protected TranslationBundleContext bundleContext;
    protected EntityReferenceSerializer<String> serializer;
    protected Provider<XWikiContext> contextProvider;
    protected ObservationManager observation;
    protected TranslationMessageParser translationMessageParser;
    protected List<Event> events;
    protected boolean disposed;
    protected DocumentReference documentReference;
    protected String idPrefix;

    public AbstractDocumentTranslationBundle(String idPrefix, DocumentReference reference, ComponentManager componentManager, TranslationMessageParser translationMessageParser) throws ComponentLookupException {
        this.idPrefix = idPrefix;
        this.componentManager = componentManager;
        this.bundleContext = (TranslationBundleContext)componentManager.getInstance(TranslationBundleContext.class);
        this.serializer = (EntityReferenceSerializer)componentManager.getInstance((Type)EntityReferenceSerializer.TYPE_STRING);
        this.contextProvider = (Provider)componentManager.getInstance((Type)XWikiContext.TYPE_PROVIDER);
        this.observation = (ObservationManager)componentManager.getInstance(ObservationManager.class);
        this.translationMessageParser = translationMessageParser;
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
        this.setPriority(900);
        this.setReference(reference);
        this.initialize();
    }

    private void initialize() {
        this.events = Arrays.asList(new DocumentUpdatedEvent(this.documentReference), new DocumentCreatedEvent(this.documentReference), new DocumentDeletedEvent(this.documentReference), new WikiDeletedEvent(this.documentReference.getWikiReference().getName()));
        this.observation.addListener((EventListener)this, 100);
    }

    protected void setReference(DocumentReference reference) {
        this.documentReference = reference;
        this.setId(this.idPrefix + (String)this.serializer.serialize((EntityReference)reference, new Object[0]));
    }

    protected XWikiDocument getDocumentLocaleBundle(Locale locale) throws Exception {
        XWikiContext context = (XWikiContext)this.contextProvider.get();
        if (context == null) {
            return null;
        }
        XWiki xwiki = context.getWiki();
        if (xwiki == null) {
            return null;
        }
        XWikiDocument document = xwiki.getDocument(this.documentReference, context);
        if (locale != null && !locale.equals(Locale.ROOT) && !locale.equals(document.getDefaultLocale())) {
            document = xwiki.getDocument(new DocumentReference((EntityReference)document.getDocumentReference(), locale), context);
        }
        return document;
    }

    protected LocalizedTranslationBundle loadDocumentLocaleBundle(Locale locale) throws Exception {
        XWikiDocument document = this.getDocumentLocaleBundle(locale);
        if (document == null) {
            return null;
        }
        if (document.isNew()) {
            return LocalizedTranslationBundle.EMPTY;
        }
        String content = document.getContent();
        Properties properties = new Properties();
        properties.load(new StringReader(content));
        DefaultLocalizedTranslationBundle localeBundle = new DefaultLocalizedTranslationBundle((TranslationBundle)this, locale);
        TranslationMessageParser parser = this.getTranslationMessageParser();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String message = (String)entry.getValue();
            TranslationMessage translationMessage = parser.parse(message);
            localeBundle.addTranslation((Translation)new DefaultTranslation(this.bundleContext, (LocalizedTranslationBundle)localeBundle, key, translationMessage));
        }
        return localeBundle;
    }

    protected TranslationMessageParser getTranslationMessageParser() {
        return this.translationMessageParser;
    }

    protected LocalizedTranslationBundle createBundle(Locale locale) throws Exception {
        return this.loadDocumentLocaleBundle(locale);
    }

    public Translation getTranslation(String key, Locale locale) {
        if (this.disposed) {
            return null;
        }
        return super.getTranslation(key, locale);
    }

    public void dispose() {
        this.disposed = true;
        this.bundleCache.clear();
        this.observation.removeListener(this.getName());
    }

    public void onEvent(Event event, Object source, Object data) {
        if (event instanceof WikiDeletedEvent) {
            this.bundleCache.clear();
            this.disposed = true;
        } else {
            XWikiDocument document = (XWikiDocument)source;
            this.bundleCache.remove(document.getLocale());
            if (document.getLocale().equals(Locale.ROOT)) {
                this.bundleCache.remove(document.getDefaultLocale());
            }
        }
    }

    public String getName() {
        return "localization.bundle." + this.getId();
    }

    public List<Event> getEvents() {
        return this.events;
    }
}

