/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.localization.ContextualLocalizationManager;
import org.xwiki.localization.LocalizationContext;
import org.xwiki.localization.LocalizationException;
import org.xwiki.localization.LocalizationManager;
import org.xwiki.localization.Translation;
import org.xwiki.rendering.syntax.Syntax;

@Component
@Singleton
public class DefaultContextualLocalizationManager
implements ContextualLocalizationManager {
    @Inject
    private LocalizationManager localizationManager;
    @Inject
    private LocalizationContext localizationContext;

    @Override
    public Translation getTranslation(String key) {
        return this.localizationManager.getTranslation(key, this.localizationContext.getCurrentLocale());
    }

    @Override
    public String getTranslationPlain(String key, Object ... parameters) {
        String result;
        try {
            result = this.getTranslation(key, Syntax.PLAIN_1_0, parameters);
        }
        catch (LocalizationException e) {
            result = null;
        }
        return result;
    }

    @Override
    public String getTranslation(String key, Syntax targetSyntax, Object ... parameters) throws LocalizationException {
        return this.localizationManager.getTranslation(key, this.localizationContext.getCurrentLocale(), targetSyntax, parameters);
    }
}

