/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import org.slf4j.LoggerFactory;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.localization.TranslationBundleContext;
import org.xwiki.localization.internal.AbstractCachedTranslationBundle;
import org.xwiki.localization.internal.DefaultLocalizedTranslationBundle;
import org.xwiki.localization.internal.DefaultTranslation;
import org.xwiki.localization.internal.LocalizedTranslationBundle;
import org.xwiki.localization.message.TranslationMessage;
import org.xwiki.localization.message.TranslationMessageParser;

public abstract class AbstractURLResourceTranslationBundle
extends AbstractCachedTranslationBundle {
    public static final String ID_PREFIX = "resource:";
    private static final String PROPERTIES_EXT = ".properties";
    @Inject
    protected TranslationBundleContext bundleContext;
    protected TranslationMessageParser translationMessageParser;
    protected URL baseURL;

    public AbstractURLResourceTranslationBundle(URL baseURL, ComponentManager componentManager, TranslationMessageParser translationMessageParser) throws ComponentLookupException {
        this.bundleContext = (TranslationBundleContext)componentManager.getInstance(TranslationBundleContext.class);
        this.translationMessageParser = translationMessageParser;
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.baseURL = baseURL;
        this.setId(ID_PREFIX + String.valueOf(baseURL));
    }

    protected URL getLocaleURL(Locale locale) {
        String urlString = this.baseURL.toString();
        Object localeURL = urlString;
        if (!locale.equals(Locale.ROOT)) {
            if (urlString.endsWith(PROPERTIES_EXT)) {
                int index = urlString.lastIndexOf(46);
                localeURL = urlString.substring(0, index);
                localeURL = (String)localeURL + "_" + locale.toString();
                localeURL = (String)localeURL + PROPERTIES_EXT;
            } else {
                return null;
            }
        }
        try {
            return new URL((String)localeURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    protected LocalizedTranslationBundle loadResourceLocaleBundle(Locale locale) {
        URL localeURL = this.getLocaleURL(locale);
        if (localeURL == null) {
            return LocalizedTranslationBundle.EMPTY;
        }
        Properties properties = new Properties();
        try (InputStream componentListStream = localeURL.openStream();){
            properties.load(componentListStream);
        }
        catch (FileNotFoundException e) {
            return LocalizedTranslationBundle.EMPTY;
        }
        catch (IOException e) {
            this.logger.error("Failed to parse resource [{}] as translation bundle", (Object)localeURL, (Object)e);
        }
        DefaultLocalizedTranslationBundle localeBundle = new DefaultLocalizedTranslationBundle(this, locale);
        TranslationMessageParser parser = this.getTranslationMessageParser();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String key = (String)entry.getKey();
            String message = (String)entry.getValue();
            TranslationMessage translationMessage = parser.parse(message);
            localeBundle.addTranslation(new DefaultTranslation(this.bundleContext, localeBundle, key, translationMessage));
        }
        return localeBundle;
    }

    protected TranslationMessageParser getTranslationMessageParser() {
        return this.translationMessageParser;
    }

    @Override
    protected LocalizedTranslationBundle createBundle(Locale locale) {
        return this.loadResourceLocaleBundle(locale);
    }
}

