/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.localization;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public class LocaleUtils
extends org.apache.commons.lang3.LocaleUtils {
    public static Locale getParentLocale(Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (StringUtils.isEmpty((CharSequence)language)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)country)) {
            return Locale.ROOT;
        }
        if (StringUtils.isEmpty((CharSequence)variant)) {
            return new Locale(language);
        }
        return new Locale(language, country);
    }

    public static Locale toLocale(String str) {
        if (str != null && str.isEmpty()) {
            return Locale.ROOT;
        }
        return org.apache.commons.lang3.LocaleUtils.toLocale((String)str);
    }

    public static Locale toLocale(String str, Locale fallback) {
        try {
            return LocaleUtils.toLocale(str);
        }
        catch (Exception e) {
            return fallback;
        }
    }

    public static boolean isValid(Locale locale) {
        if (locale != null) {
            try {
                LocaleUtils.toLocale(locale.toString());
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static List<Locale> availableLocaleList() {
        return SyncAvoid.AVAILABLE_LOCALE_LIST;
    }

    public static Set<Locale> availableLocaleSet() {
        return SyncAvoid.AVAILABLE_LOCALE_SET;
    }

    static class SyncAvoid {
        private static final List<Locale> AVAILABLE_LOCALE_LIST;
        private static final Set<Locale> AVAILABLE_LOCALE_SET;

        SyncAvoid() {
        }

        static {
            Locale[] jvmLocales = Locale.getAvailableLocales();
            ArrayList<Locale> list = new ArrayList<Locale>(jvmLocales.length);
            for (Locale jvmLocale : jvmLocales) {
                if (!LocaleUtils.isValid(jvmLocale)) continue;
                list.add(jvmLocale);
            }
            AVAILABLE_LOCALE_LIST = Collections.unmodifiableList(list);
            AVAILABLE_LOCALE_SET = Collections.unmodifiableSet(new HashSet(list));
        }
    }
}

