const o = {
  inject: ["logic"],
  props: {
    propertyId: String,
    index: Number
  },
  data() {
    return {
      _applyFilterTimeoutId: void 0
    };
  },
  // The computed values provide common data needed by filters
  computed: {
    // The filter group (the whole filter configuration) of `this.propertyId`
    filterGroup() {
      return this.logic.getQueryFilterGroup(this.propertyId) || {};
    },
    // The filter entry (the filter at `this.index`) of `this.propertyId`
    filterEntry() {
      return (this.filterGroup.constraints || [])[this.index] || {};
    },
    // The operator used, or default one if none specified
    operator() {
      return this.filterEntry.operator || this.logic.getFilterDefaultOperator(this.propertyId);
    },
    // The property descriptor of `this.propetyId`
    propertyDescriptor() {
      return this.logic.getPropertyDescriptor(this.propertyId);
    },
    // The configuration (aka filterDescriptor) of the filter
    config() {
      return this.logic.getFilterDescriptor(this.propertyId);
    },
    // The whole Livedata data object
    data() {
      return this.logic.data;
    }
  },
  methods: {
    // This method should be used to apply filter.
    // Since only the newValue has to be specified it is less error prone.
    /**
     * @param newValue the new filtering value
     * @param filterOperator the operator to apply, when undefined the default operator is used
     * @param skipFetch when true, the filter will be applied on the reactive variables, but will not trigger an
     * fetch. When undefined, the default value is false. This paramter is important in the case of asynchronous
     * methods where we need to have an instance feedback on the UI (e.g., between the advanced filtering panel and
     * the top filters in the table layout)
     */
    applyFilter: async function(e, i = void 0, t = !1) {
      t || this.$emit("update:isFiltering", !0);
      try {
        this.logic.filter(this.propertyId, this.index, { value: e }, { filterOperator: i, skipFetch: t });
      } finally {
        t || this.$emit("update:isFiltering", !1);
      }
    },
    removeFilter: function() {
      this.$emit("update:isFiltering", !0), this.logic.removeFilter(this.propertyId, this.index).finally(() => {
        this.$emit("update:isFiltering", !1);
      });
    },
    // Call applyFilter method, but using a delay
    // This can be used when we want to call the applyFilter method inside an input event
    applyFilterWithDelay(e) {
      this.applyFilter(e, void 0, !0), clearTimeout(this._applyFilterTimeoutId);
      const i = 250;
      this._applyFilterTimeoutId = setTimeout(() => {
        this.logic.updateEntries();
      }, i);
    },
    // This method is automatically called by the widget when the operator change
    // It allow to decide what to do with the current value,
    // according to the new chosen operator
    // and the rules defined in the data function of the widget
    _operatorChangeHandler(e, i) {
      this.rules && this.rules.slice().reverse().some((t) => {
        if (t.from instanceof Array || (t.from = [t.from]), t.to instanceof Array || (t.to = [t.to]), !t.from.includes(e) || !t.to.includes(i))
          return;
        const r = t.getValue({
          oldValue: this.filterEntry.value,
          oldOperator: e,
          newOperator: i
        });
        this.applyFilter(r);
      });
    }
  },
  created() {
    this.logic.onEventWhere("filter", {
      type: "modify",
      oldEntry: { property: this.propertyId, index: this.index }
    }, (e) => {
      e.detail.oldEntry.operator !== e.detail.newEntry.operator && (e.stopImmediatePropagation(), this._operatorChangeHandler(e.detail.oldEntry.operator, e.detail.newEntry.operator));
    });
  }
};
export {
  o as f
};
//# sourceMappingURL=filterMixin-d-cNz5s1.js.map
