import { _ as s, a as d, c } from "./main-CkFK4rnR.js";
import { markRaw as p, resolveComponent as f, createBlock as n, openBlock as o, Suspense as m, withCtx as u, resolveDynamicComponent as h, normalizeClass as F } from "vue";
const g = {
  name: "LivedataFilter",
  inject: ["logic"],
  components: {
    XWikiLoader: d
  },
  // The two props defining the Filter
  props: {
    propertyId: String,
    index: Number,
    isAdvanced: {
      type: Boolean,
      default: !1
    }
  },
  data() {
    return {
      // The filter component used to filter the property
      // It is set to `undefined before it is resolved
      filterComponent: void 0,
      isFiltering: !1
    };
  },
  computed: {
    data() {
      return this.logic.data;
    },
    // The filter id of the Filter component to load
    // corresponding to the property id
    filterId() {
      return this.logic.getFilterDescriptor(this.propertyId).id;
    }
  },
  methods: {
    // Capitalize the given string
    capitalize(e) {
      return e ??= "", e[0].toUpperCase() + e.slice(1);
    },
    // Load the filter component corresponding to the given filterId
    // On success, set `this.filterComponent` to the retreived component,
    // which automatically insert the component in the html
    async loadFilter(e) {
      const t = await c.load("filter", e ?? this.filterId);
      if (!t)
        throw new Error(`Unknown filter [${e}]`);
      return this.filterComponent = p(t), t;
    }
  },
  // On mounted, try to load the Filter corresponding to the passed props,
  // or the default one as fallback
  mounted() {
    this.loadFilter().catch((e) => {
      console.warn(e), this.loadFilter(this.data.meta.defaultFilter).catch((t) => {
        console.error(t);
      });
    });
  }
};
function v(e, t, r, y, i, _) {
  const l = f("XWikiLoader");
  return o(), n(m, null, {
    default: u(() => [
      i.filterComponent ? (o(), n(h(i.filterComponent), {
        key: 0,
        class: F(["livedata-filter", i.isFiltering ? "filtering" : ""]),
        "property-id": r.propertyId,
        index: r.index,
        "is-filtering": i.isFiltering,
        "onUpdate:isFiltering": t[0] || (t[0] = (a) => i.isFiltering = a),
        "is-advanced": r.isAdvanced
      }, null, 40, ["class", "property-id", "index", "is-filtering", "is-advanced"])) : (o(), n(l, {
        key: 1,
        class: "livedata-filter-loader"
      }))
    ]),
    _: 1
  });
}
const x = /* @__PURE__ */ s(g, [["render", v]]);
export {
  x as L
};
//# sourceMappingURL=LivedataFilter-CokHnDEB.js.map
