import { f as n } from "./filterMixin-d-cNz5s1.js";
import { _ as c, a as h } from "./main-CkFK4rnR.js";
import { l as d } from "./require-Dl4qyrU9.js";
import { resolveComponent as p, withDirectives as u, createBlock as f, createElementBlock as y, openBlock as l, createElementVNode as m, vShow as g } from "vue";
const v = {
  name: "filter-list",
  components: { XWikiLoader: h },
  // Add the filterMixin to get access to all the generic filter methods and computed properties inside this component.
  mixins: [n],
  inject: ["jQuery"],
  props: {
    isAdvanced: {
      type: Boolean,
      default: !1
    }
  },
  data() {
    return {
      isReady: !1,
      selectizeLoaded: !1
    };
  },
  async created() {
    await d("xwiki-selectize"), this.selectizeLoaded = !0;
  },
  computed: {
    // Current value of the filter entry.
    value() {
      return this.filterEntry.value;
    },
    fullyReady() {
      return this.isReady && this.selectizeLoaded;
    },
    // Settings used when creating the selectize widget.
    selectizeSettings() {
      let e = this.config.options || [];
      !this.isAdvanced && this.hasEmptyOperator && this.filterEntry?.operator === "empty" && !e.some((i) => i.value === "") && e.push(this.getDefaultEmptyOption());
      const t = {
        // Allow free text because we want to support the contains and startsWith operators.
        create: !0,
        // Take the list of (initial) options from the filter configuration. This list will be extended with the results
        // obtained from the configured search URL.
        options: e,
        // Limit the selection to a single value because:
        // * selecting multiple values increases the height of the filter row when table layout is used
        // * constraint (filter) values should be strings; this isn't a limitation of the live data model, but using
        //   arrays or complex objects make it difficult to express the filter in the REST URL used to fetch the live
        //   data or in the live data macro parameters
        // * the user can still add more values by adding more constraints from the advanced filtering panel
        maxItems: 1,
        onChange: (i) => {
          this.$refs.input.selectize.items.length === 0 ? this.removeFilter() : i !== this.value && (i === "" ? this.applyFilter(i, "empty") : this.applyFilter(i));
        }
      };
      return this.config.searchURL && Object.assign(t, {
        load: this.getLoader({ limit: 10 }),
        loadSelected: this.getLoader({ exactMatch: !0 })
      }), t;
    },
    isVisible() {
      return this.filterEntry.operator !== "empty" || !this.isAdvanced;
    },
    hasEmptyOperator() {
      return this.config.operators.some((e) => e.id === "empty");
    }
  },
  methods: {
    // Creates the function to fetch the suggestions using the given parameters.
    getLoader(e) {
      return (t, i) => {
        const a = this.config.searchURL.replace("{encodedQuery}", encodeURIComponent(t));
        this.jQuery.getJSON(a, e).then((s) => i(this.getResultsAdapter(s))).catch(() => i(this.getResultsAdapter()));
      };
    },
    getResultsAdapter(e) {
      let t = [];
      return Array.isArray(e) ? t = e : Array.isArray(e?.propertyValues) && (t = e.propertyValues.map(this.getSuggestion)), !this.isAdvanced && this.hasEmptyOperator && !t.some((i) => i.value === "") && t.unshift(this.getDefaultEmptyOption()), t;
    },
    // Convert the fetched data to the format expected by the selectize widget.
    getSuggestion(e) {
      const t = e.metaData || e;
      return {
        value: e.value,
        label: t.label,
        icon: t.icon,
        url: t.url,
        hint: t.hint
      };
    },
    getDefaultEmptyOption() {
      return {
        value: "",
        label: this.$t("livedata.filter.list.emptyLabel")
      };
    }
  },
  // Update the selectize widget whenever the filter value changes.
  watch: {
    value(e) {
      this.jQuery(this.$refs.input).val(e).trigger("change");
    },
    async fullyReady(e) {
      if (e) {
        await this.$nextTick();
        const t = this.jQuery;
        t(this.$refs.input).xwikiSelectize(this.selectizeSettings), this.filterEntry?.operator === "empty" && t(this.$refs.input).val(",").trigger("change");
      }
    }
  },
  // Create the selectize widget.
  async mounted() {
    await this.logic.translationsLoaded(), this.isReady = !0;
  },
  // Destroy the selectize widget.
  beforeDestroyed() {
    this.$refs.input.selectize?.destroy();
  }
}, L = { key: 0 }, _ = ["value", "aria-label"];
function R(e, t, i, a, s, r) {
  const o = p("XWikiLoader");
  return s.isReady && s.selectizeLoaded ? u((l(), y("span", L, [
    m("input", {
      value: r.value,
      class: "filter-list livedata-filter",
      ref: "input",
      "aria-label": this.$t("livedata.filter.list.label")
    }, null, 8, _)
  ], 512)), [
    [g, r.isVisible]
  ]) : (l(), f(o, { key: 1 }));
}
const x = /* @__PURE__ */ c(v, [["render", R]]);
export {
  x as default
};
//# sourceMappingURL=FilterList-CJ48HRJ8.js.map
