import { f } from "./filterMixin-d-cNz5s1.js";
import { l as i } from "./require-Dl4qyrU9.js";
import { createElementBlock as n, createCommentVNode as d, openBlock as s } from "vue";
import { _ as u } from "./main-CkFK4rnR.js";
const h = {
  name: "filter-date",
  // Add the filterMixin to get access to all the filters methods and computed properties inside this component
  mixins: [f],
  inject: ["jQuery"],
  data() {
    return {
      rules: [
        {
          from: "contains",
          to: ["before", "after", "between"],
          getValue: () => ""
        },
        {
          from: ["before", "after", "between"],
          to: "contains",
          getValue: ({ oldValue: t }) => {
            const e = this.moment((t + "").split("/")[0]);
            return e.isValid() ? e.format(this.format) : t;
          }
        },
        {
          // between x and y => after x and before y
          from: "between",
          to: "before",
          getValue: ({ oldValue: t }) => (t + "").split("/")[1] || t
        },
        {
          from: "between",
          to: "after",
          getValue: ({ oldValue: t }) => typeof t == "string" ? t.split("/")[0] : t
        },
        {
          from: ["before", "after"],
          to: "between",
          getValue: ({ oldValue: t }) => this.moment(t + "").isValid() ? t + "/" + t : t
        }
      ],
      moment: null,
      dependenciesloaded: !1
    };
  },
  computed: {
    valueFormatted() {
      if (typeof this.filterEntry.value == "string" && this.filterEntry.value.length) {
        const t = this.filterEntry.value.split("/");
        if (t.length <= 2)
          return t.map((e) => {
            const a = this.moment(e);
            return a.isValid() ? a.format(this.format) : e;
          }).join(" - ");
      }
      return this.filterEntry.value;
    },
    showDateInput() {
      return this.operator !== "contains";
    },
    format() {
      const t = this.config.dateFormat;
      return t ? this.moment().toMomentFormatString(t) : "YYYY/MM/DD HH:mm";
    },
    ranges() {
      return {
        Today: [this.moment().startOf("day"), this.moment().endOf("day")],
        Yesterday: [
          this.moment().subtract(1, "days").startOf("day"),
          this.moment().subtract(1, "days").endOf("day")
        ],
        "Last 7 days": [this.moment().subtract(6, "days").startOf("day"), this.moment().endOf("day")],
        "Last 30 days": [this.moment().subtract(29, "days").startOf("day"), this.moment().endOf("day")],
        "This month": [this.moment().startOf("month"), this.moment().endOf("month")],
        "Last month": [
          this.moment().subtract(1, "month").startOf("month"),
          this.moment().subtract(1, "month").endOf("month")
        ]
      };
    },
    defaultFilterConfig() {
      return {
        drops: "down",
        opens: "right",
        autoUpdateInput: !1,
        autoApply: !1,
        singleDatePicker: !0,
        timePicker: /[Hhkms]/.test(this.format),
        timePicker24Hour: !0,
        showCustomRangeLabel: !0,
        alwaysShowCalendars: !0,
        locale: {
          format: this.format,
          cancelLabel: "Clear"
        }
      };
    },
    filterConfig() {
      return this.operator === "between" ? {
        ...this.defaultFilterConfig,
        singleDatePicker: !1,
        ranges: this.ranges
      } : { ...this.defaultFilterConfig };
    }
  },
  methods: {
    // Get date filter value from input element
    getDateValue() {
      const t = this.jQuery(this.$refs.filterDate).data("daterangepicker");
      return this.operator === "between" ? `${t.startDate.format()}/${t.endDate.add(
        59,
        "seconds"
      ).format()}` : this.operator === "before" || this.operator === "after" ? t.startDate.format() : t.startDate.format(this.format);
    },
    applyFilterFromDate() {
      const t = this.getDateValue();
      this.applyFilter(t);
    },
    applyFilterFromText() {
      const t = this.jQuery(this.$refs.containsInput).val();
      this.applyFilterWithDelay(t);
    }
  },
  async mounted() {
    this.moment = await i("moment"), await i("daterangepicker"), await i("moment-jdateformatparser"), this.dependenciesloaded = !0, this.$watch(
      () => ({
        filterConfig: this.filterConfig,
        loaded: this.dependenciesloaded
      }),
      async ({ loaded: t }) => {
        if (!t)
          return;
        await this.$nextTick();
        const e = this.$refs.filterDate, a = this.jQuery;
        a(e).daterangepicker(
          this.filterConfig
        ), a(e).on("apply.daterangepicker", () => {
          this.applyFilterFromDate();
        }), a(e).on("cancel.daterangepicker", () => {
          this.applyFilter("");
        }), a(e).on("hide.daterangepicker", (o) => {
          e.hide = void 0, setTimeout(function() {
            delete o.target.hide;
          }, 0);
        });
      },
      { immediate: !0 }
    );
  }
}, p = { key: 0 }, c = ["aria-label", "value"], y = ["aria-label", "value"];
function g(t, e, a, o, l, r) {
  return l.dependenciesloaded ? (s(), n("div", p, [
    r.showDateInput ? (s(), n("input", {
      class: "filter-date",
      ref: "filterDate",
      key: "filterDate",
      type: "text",
      size: "1",
      "aria-label": t.$t("livedata.filter.date.label"),
      value: r.valueFormatted
    }, null, 8, c)) : (s(), n("input", {
      class: "filter-date",
      ref: "containsInput",
      key: "containsInput",
      type: "text",
      size: "1",
      "aria-label": t.$t("livedata.filter.date.label"),
      value: t.filterEntry.value,
      onInput: e[0] || (e[0] = (...m) => r.applyFilterFromText && r.applyFilterFromText(...m))
    }, null, 40, y))
  ])) : d("", !0);
}
const v = /* @__PURE__ */ u(h, [["render", g]]);
export {
  v as default
};
//# sourceMappingURL=FilterDate-ZesrTwJJ.js.map
